/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.application;

import com.aeontronix.commons.file.FileUtils;
import com.aeontronix.commons.xml.XPathUtils;
import com.aeontronix.commons.xml.XmlUtils;
import com.aeontronix.enhancedmule.tools.application.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.application.ApplicationSourceEnhancementException;
import com.aeontronix.restclient.RESTClient;
import com.aeontronix.restclient.RESTException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ApplicationSourceEnhancer {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationSourceEnhancer.class);
    private RESTClient restClient;
    private File projectDir;

    public ApplicationSourceEnhancer(RESTClient restClient, File projectDir) {
        this.restClient = restClient;
        this.projectDir = projectDir;
    }

    public void execute() throws ApplicationSourceEnhancementException {
        try {
            File pomFile = new File(this.projectDir, "pom.xml");
            if (!pomFile.exists()) {
                throw new IOException("pom.xml not found: " + pomFile.getPath());
            }
            Document pomDoc = XmlUtils.parse((File)pomFile, (boolean)false);
            this.setupEmtMavenPlugin(pomDoc);
            this.disableExchangePreDeploy(pomDoc);
            this.setupAnypointJson(this.projectDir);
            this.setupEnhancedMuleProperties(this.projectDir, pomDoc);
            try (FileOutputStream fos = new FileOutputStream(pomFile);){
                XmlUtils.serialize((Node)pomDoc, (OutputStream)fos, (boolean)true, (boolean)true);
            }
        }
        catch (Exception e) {
            throw new ApplicationSourceEnhancementException(e);
        }
        logger.info("Application enhancement completed");
    }

    private void setupEnhancedMuleProperties(File projectDir, Document pomDoc) throws XPathExpressionException, IOException, RESTException {
        String artifactId = "enhanced-mule-properties-provider";
        String groupId = "com.aeontronix.enhanced-mule";
        String newVersion = this.getLatestVersion("39986379");
        Element depVersion = XPathUtils.evalXPathElement((String)("//dependencies/dependency[ artifactId/text() = '" + artifactId + "' and groupId/text() = '" + groupId + "']/version"), (Node)pomDoc);
        if (depVersion != null) {
            String oldVersion = depVersion.getTextContent().trim();
            if (!oldVersion.equals(newVersion)) {
                depVersion.setTextContent(newVersion);
                logger.info("Updated version of " + groupId + ":" + artifactId + " from " + oldVersion + " to " + newVersion);
            }
        } else {
            Element dependencies = XmlUtils.getChildElement((Node)pomDoc.getDocumentElement(), (String)"dependencies", (boolean)true);
            Element dependency = XmlUtils.createElement((String)"dependency", (Node)dependencies, (Object[])new Object[0]);
            XmlUtils.createElement((String)"groupId", (Node)dependency, (Object[])new Object[0]).setTextContent(groupId);
            XmlUtils.createElement((String)"artifactId", (Node)dependency, (Object[])new Object[0]).setTextContent(artifactId);
            XmlUtils.createElement((String)"version", (Node)dependency, (Object[])new Object[0]).setTextContent(newVersion);
            XmlUtils.createElement((String)"classifier", (Node)dependency, (Object[])new Object[0]).setTextContent("mule-plugin");
            logger.info("Added dependency " + groupId + ":" + artifactId + ":" + newVersion);
            File propertiesXml = new File(projectDir.getPath() + File.separator + "src" + File.separator + "main" + File.separator + "mule" + File.separator + "properties.xml");
            if (!propertiesXml.exists()) {
                FileUtils.write((File)propertiesXml, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<mule xmlns:enhanced-mule-properties=\"http://www.mulesoft.org/schema/mule/enhanced-mule-properties\" xmlns=\"http://www.mulesoft.org/schema/mule/core\"\n\txmlns:doc=\"http://www.mulesoft.org/schema/mule/documentation\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd\nhttp://www.mulesoft.org/schema/mule/enhanced-mule-properties http://www.mulesoft.org/schema/mule/enhanced-mule-properties/current/mule-enhanced-mule-properties.xsd\">\n\t<enhanced-mule-properties:config name=\"Enhanced_Mule_Properties_Config\" doc:name=\"Enhanced Mule Properties Config\" doc:id=\"a35802ca-2aa9-43c0-8c16-11db87f94841\" />\n</mule>\n");
                logger.info("Added src/main/mule/properties.xml");
            }
        }
        File propFile = new File(projectDir.getPath() + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "properties.yaml");
        if (!propFile.exists()) {
            FileUtils.write((File)propFile, (String)"http.listener:\n  type: https\n  name: HTTPS Listener properties\n  description: HTTP listener properties plus self-signed cert");
        }
    }

    private void setupAnypointJson(File projectDir) throws IOException {
        File file = new File(projectDir, "anypoint.json");
        if (!file.exists()) {
            logger.info("anypoint.json missing, creating");
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)new JavaTimeModule());
            objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            ObjectNode defs = (ObjectNode)ApplicationDescriptor.createDefault(objectMapper);
            ObjectNode desc = objectMapper.createObjectNode();
            desc.put("$schema", "https://docs.enhanced-mule.com/schemas/emule-application-1.0.schema.json");
            desc.set("deploymentParams", defs.get("deploymentParams"));
            ArrayNode overrides = objectMapper.createArrayNode();
            desc.set("overrides", (JsonNode)overrides);
            ObjectNode override = objectMapper.createObjectNode();
            overrides.add((JsonNode)override);
            override.put("type", "envType");
            override.put("value", "production");
            ObjectNode overrideObj = (ObjectNode)ApplicationDescriptor.createDefault(objectMapper);
            override.set("override", (JsonNode)overrideObj);
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)desc);
        } else {
            logger.info("anypoint.json exists, skipping");
        }
    }

    private void setupEmtMavenPlugin(Document pomDoc) throws XPathExpressionException, RESTException {
        String emtVersion = this.getLatestVersion("14801271");
        Element emPluginVersion = XPathUtils.evalXPathElement((String)"//build/plugins/plugin[ artifactId/text() = 'enhanced-mule-tools-maven-plugin' and groupId/text() = 'com.aeontronix.enhanced-mule']/version", (Node)pomDoc);
        Element mvnProject = pomDoc.getDocumentElement();
        if (emPluginVersion == null) {
            logger.info("EMT maven plugin missing, adding");
            Element build = XmlUtils.getChildElement((Node)mvnProject, (String)"build", (boolean)true);
            Element plugins = XmlUtils.getChildElement((Node)build, (String)"plugins", (boolean)true);
            Element plugin = XmlUtils.createElement((String)"plugin", (Node)plugins, (Object[])new Object[0]);
            XmlUtils.createElement((String)"groupId", (Node)plugin, (Object[])new Object[0]).setTextContent("com.aeontronix.enhanced-mule");
            XmlUtils.createElement((String)"artifactId", (Node)plugin, (Object[])new Object[0]).setTextContent("enhanced-mule-tools-maven-plugin");
            XmlUtils.createElement((String)"version", (Node)plugin, (Object[])new Object[0]).setTextContent(emtVersion);
            Element executions = XmlUtils.createElement((String)"executions", (Node)plugin, (Object[])new Object[0]);
            Element execution = XmlUtils.createElement((String)"execution", (Node)executions, (Object[])new Object[0]);
            Element goals = XmlUtils.createElement((String)"goals", (Node)execution, (Object[])new Object[0]);
            XmlUtils.createElement((String)"goal", (Node)goals, (Object[])new Object[0]).setTextContent("process-descriptor");
            XmlUtils.createElement((String)"goal", (Node)goals, (Object[])new Object[0]).setTextContent("deploy");
        } else {
            logger.info("EMT maven plugin found, updating version to " + emtVersion);
            emPluginVersion.setTextContent(emtVersion);
        }
        Element properties = XmlUtils.getChildElement((Node)mvnProject, (String)"properties", (boolean)true);
        XmlUtils.getChildElement((Node)properties, (String)"maven.deploy.skip", (boolean)true).setTextContent("true");
    }

    private void disableExchangePreDeploy(Document pomDoc) throws XPathExpressionException, RESTException {
        Element plugin = XPathUtils.evalXPathElement((String)"//build/plugins/plugin[ artifactId/text() = 'exchange-mule-maven-plugin' and groupId/text() = 'org.mule.tools.maven']", (Node)pomDoc);
        if (plugin == null) {
            logger.info("adding exchange-mule-maven-plugin");
            Element mvnProject = pomDoc.getDocumentElement();
            Element build = XmlUtils.getChildElement((Node)mvnProject, (String)"build", (boolean)true);
            Element plugins = XmlUtils.getChildElement((Node)build, (String)"plugins", (boolean)true);
            plugin = XmlUtils.createElement((String)"plugin", (Node)plugins, (Object[])new Object[0]);
            XmlUtils.createElement((String)"groupId", (Node)plugin, (Object[])new Object[0]).setTextContent("org.mule.tools.maven");
            XmlUtils.createElement((String)"artifactId", (Node)plugin, (Object[])new Object[0]).setTextContent("exchange-mule-maven-plugin");
            XmlUtils.createElement((String)"version", (Node)plugin, (Object[])new Object[0]).setTextContent("0.0.17");
        }
        logger.info("Setting exchange-mule-maven-plugin to skip");
        Element config = XmlUtils.getChildElement((Node)plugin, (String)"configuration", (boolean)true);
        XmlUtils.getChildElement((Node)config, (String)"skip", (boolean)true).setTextContent("true");
    }

    private String getLatestVersion(String projectId) throws RESTException {
        Map rel = (Map)((List)this.restClient.get("https://gitlab.com/api/v4/projects/" + projectId + "/releases", List.class)).get(0);
        return ((String)rel.get("tag_name")).substring(1);
    }
}

