/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.application.deployment;

import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.RTFDeploymentConfig;
import com.aeontronix.enhancedmule.tools.application.deployment.CloudhubDeploymentParameters;
import com.aeontronix.enhancedmule.tools.application.deployment.RTFDeploymentParameters;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public class DeploymentParameters {
    private String target;
    private CloudhubDeploymentParameters cloudhub;
    private RTFDeploymentParameters rtf;
    private Duration deployTimeout;
    private Duration deployRetryDelay;
    private Boolean mergeExistingProperties;
    private Boolean mergeExistingPropertiesOverride;
    private Boolean extMonitoring;
    private Boolean autoApproveAccess;

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @NotNull
    public CloudhubDeploymentParameters getCloudhub() {
        if (this.cloudhub == null) {
            this.cloudhub = new CloudhubDeploymentParameters();
        }
        return this.cloudhub;
    }

    public void setCloudhub(CloudhubDeploymentParameters cloudhub) {
        this.cloudhub = cloudhub;
    }

    @NotNull
    public RTFDeploymentParameters getRtf() {
        if (this.rtf == null) {
            this.rtf = new RTFDeploymentParameters();
        }
        return this.rtf;
    }

    public void setRtf(RTFDeploymentParameters rtf) {
        this.rtf = rtf;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public Duration getDeployTimeout() {
        return this.deployTimeout;
    }

    public void setDeployTimeout(Duration deployTimeout) {
        this.deployTimeout = deployTimeout;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public Duration getDeployRetryDelay() {
        return this.deployRetryDelay;
    }

    public void setDeployRetryDelay(Duration deployRetryDelay) {
        this.deployRetryDelay = deployRetryDelay;
    }

    public Boolean getMergeExistingProperties() {
        return this.mergeExistingProperties;
    }

    public void setMergeExistingProperties(Boolean mergeExistingProperties) {
        this.mergeExistingProperties = mergeExistingProperties;
    }

    public Boolean getMergeExistingPropertiesOverride() {
        return this.mergeExistingPropertiesOverride;
    }

    public void setMergeExistingPropertiesOverride(Boolean mergeExistingPropertiesOverride) {
        this.mergeExistingPropertiesOverride = mergeExistingPropertiesOverride;
    }

    public Boolean getExtMonitoring() {
        return this.extMonitoring;
    }

    public void setExtMonitoring(Boolean extMonitoring) {
        this.extMonitoring = extMonitoring;
    }

    public Boolean getAutoApproveAccess() {
        return this.autoApproveAccess;
    }

    public void setAutoApproveAccess(Boolean autoApproveAccess) {
        this.autoApproveAccess = autoApproveAccess;
    }

    public void merge(DeploymentParameters ov) {
    }

    public static DeploymentParameters createDefault() {
        DeploymentParameters dp = new DeploymentParameters();
        dp.setDeployTimeout(Duration.ofMinutes(15L));
        dp.setDeployRetryDelay(Duration.ofSeconds(3L));
        dp.setMergeExistingProperties(false);
        dp.setMergeExistingPropertiesOverride(false);
        dp.setExtMonitoring(true);
        dp.setAutoApproveAccess(true);
        CloudhubDeploymentParameters ch = dp.getCloudhub();
        ch.setAppNameSuffixNPOnly(false);
        ch.setObjectStoreV1(false);
        ch.setPersistentQueues(false);
        ch.setPersistentQueuesEncrypted(false);
        ch.setCustomlog4j(false);
        ch.setStaticIPs(false);
        ch.setWorkerCount(1);
        RTFDeploymentParameters rtf = dp.getRtf();
        rtf.setCpuReserved("20m");
        rtf.setCpuLimit("1700m");
        rtf.setCpuLimit("1700m");
        rtf.setMemoryReserved("700Mi");
        rtf.setMemoryLimit("700Mi");
        rtf.setClustered(false);
        rtf.setEnforceDeployingReplicasAcrossNodes(false);
        rtf.setUpdateStrategy(RTFDeploymentConfig.DeploymentModel.ROLLING);
        rtf.setReplicas(1);
        return dp;
    }
}

