/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.emclient;

import com.aeontronix.commons.URLBuilder;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.config.ConfigProfile;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.authentication.AuthenticationProviderBearerTokenImpl;
import com.aeontronix.enhancedmule.tools.emclient.authentication.AnypointBearerTokenCredentialsProvider;
import com.aeontronix.enhancedmule.tools.emclient.authentication.CredentialsProvider;
import com.aeontronix.enhancedmule.tools.util.UnauthorizedHttpException;
import com.aeontronix.restclient.ProxySettings;
import com.aeontronix.restclient.RESTClient;
import com.aeontronix.restclient.RESTClientHost;
import com.aeontronix.restclient.RESTClientHostBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;

public class EnhancedMuleClient
implements Closeable,
AutoCloseable {
    public static final String EMULE_SERVER_URL = "https://api.enhanced-mule.com";
    private CredentialsProvider credentialsProvider;
    private String anypointPlatformUrl = "https://anypoint.mulesoft.com/";
    private String exchangeMavenBaseUrl = "https://maven.anypoint.mulesoft.com";
    private String exchangeMavenPath = "/api/v2/maven";
    private RESTClientHost anypointRestClient;
    private String serverUrl;
    private ProxySettings proxySettings;
    private String publicServerUrl;
    private ConfigProfile configProfile;
    private RESTClient restClient;
    private RESTClientHost serverRestClient;

    public EnhancedMuleClient(ConfigProfile configProfile, ProxySettings proxySettings) {
        this(EMULE_SERVER_URL, configProfile, proxySettings);
    }

    public EnhancedMuleClient(String serverUrl, ConfigProfile configProfile, ProxySettings proxySettings) {
        this.configProfile = configProfile;
        this.serverUrl = serverUrl;
        this.proxySettings = proxySettings;
        this.initRestClient();
        this.publicServerUrl = new URLBuilder(this.serverUrl).path("public").toString();
    }

    private void initRestClient() {
        this.restClient = RESTClient.builder().proxy(this.proxySettings).build();
        RESTClientHostBuilder anypointRestClientBuilder = this.restClient.host(this.anypointPlatformUrl);
        if (this.credentialsProvider != null) {
            anypointRestClientBuilder.authenticationHandler(this.credentialsProvider.toAuthenticationHandler(this.restClient, this.anypointPlatformUrl));
        }
        this.anypointRestClient = anypointRestClientBuilder.build();
        this.serverRestClient = this.restClient.host(this.serverUrl).build();
    }

    public ConfigProfile getConfigProfile() {
        return this.configProfile;
    }

    public RESTClient getRestClient() {
        return this.restClient;
    }

    public RESTClientHost getAnypointRestClient() {
        return this.anypointRestClient;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Object[])new Object[]{this.restClient});
    }

    public CredentialsProvider getCredentialsLoader() {
        return this.credentialsProvider;
    }

    public void setCredentialsLoader(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        this.initRestClient();
    }

    public AnypointClient getAnypointClient() throws IOException {
        if (this.credentialsProvider instanceof AnypointBearerTokenCredentialsProvider) {
            String anypointBearerToken = ((AnypointBearerTokenCredentialsProvider)this.credentialsProvider).getAnypointBearerToken(this);
            AnypointClient anypointClient = new AnypointClient(new AuthenticationProviderBearerTokenImpl(anypointBearerToken));
            if (this.proxySettings != null) {
                URI proxyUri = this.proxySettings.getProxyUri();
                anypointClient.setProxy(proxyUri.getScheme(), proxyUri.getHost(), proxyUri.getPort(), this.proxySettings.getProxyUsername(), this.proxySettings.getProxyPassword());
            }
            return anypointClient;
        }
        throw new RuntimeException("not implemented");
    }

    public String getAnypointPlatformUrl() {
        return this.anypointPlatformUrl;
    }

    public void setAnypointPlatformUrl(String anypointPlatformUrl) {
        this.anypointPlatformUrl = anypointPlatformUrl;
    }

    public String getExchangeMavenUrl() {
        return this.exchangeMavenBaseUrl + this.exchangeMavenPath;
    }

    public String getExchangeMavenBaseUrl() {
        return this.exchangeMavenBaseUrl;
    }

    public void setExchangeMavenBaseUrl(String exchangeMavenBaseUrl) {
        this.exchangeMavenBaseUrl = exchangeMavenBaseUrl;
    }

    public String getAnypointBearerToken() throws IOException {
        if (this.credentialsProvider instanceof AnypointBearerTokenCredentialsProvider) {
            return ((AnypointBearerTokenCredentialsProvider)this.credentialsProvider).getAnypointBearerToken(this);
        }
        throw new UnauthorizedHttpException("Not supported");
    }
}

