/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.util;

import com.aeontronix.enhancedmule.tools.cli.EMTCli;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.jline.console.CmdDesc;
import org.jline.console.CommandRegistry;
import org.jline.reader.impl.completer.SystemCompleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenExecutor
implements CommandRegistry {
    private static final Logger logger = LoggerFactory.getLogger(MavenExecutor.class);
    public static final String MVN = "mvn";
    private final Set<String> cmdNames;
    private EMTCli cli;

    public MavenExecutor(EMTCli cli) {
        this.cli = cli;
        this.cmdNames = new HashSet<String>();
        this.cmdNames.add(MVN);
    }

    public Set<String> commandNames() {
        return this.cmdNames;
    }

    public Map<String, String> commandAliases() {
        return Collections.emptyMap();
    }

    public List<String> commandInfo(String command) {
        if (command.equalsIgnoreCase(MVN)) {
            return Collections.singletonList("Invokes maven in the working directory");
        }
        return Collections.emptyList();
    }

    public boolean hasCommand(String command) {
        return MVN.equalsIgnoreCase(command);
    }

    public SystemCompleter compileCompleters() {
        return new SystemCompleter();
    }

    public CmdDesc commandDescription(List<String> args) {
        return null;
    }

    public Object invoke(CommandRegistry.CommandSession session, String command, Object ... args) throws Exception {
        if (MVN.equals(command)) {
            ArrayList<String> argsList = new ArrayList<String>();
            if (args != null) {
                for (Object arg : args) {
                    argsList.add(arg.toString());
                }
            }
            MavenExecutor.execute(this.cli.getWorkDir(), argsList);
        }
        return null;
    }

    public static int execute(File workDir, List<String> args) throws IOException {
        File mvnw = new File("mvnw");
        if (mvnw.exists()) {
            CommandLine cmd;
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                cmd = new CommandLine("mvnw.cmd");
            } else {
                cmd = new CommandLine("sh");
                cmd.addArgument("mvnw");
            }
            for (String arg : args) {
                cmd.addArgument(arg);
            }
            DefaultExecutor defaultExecutor = new DefaultExecutor();
            defaultExecutor.setWorkingDirectory(workDir);
            defaultExecutor.setExitValues(null);
            return defaultExecutor.execute(cmd);
        }
        logger.error("maven wrapper script not found");
        return -1;
    }
}

