/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.api;

import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.api.APIContract;
import com.aeontronix.enhancedmule.tools.anypoint.api.APIContractList;
import com.aeontronix.enhancedmule.tools.anypoint.api.APIEndpoint;
import com.aeontronix.enhancedmule.tools.anypoint.api.APISpec;
import com.aeontronix.enhancedmule.tools.anypoint.api.ClientApplication;
import com.aeontronix.enhancedmule.tools.anypoint.api.SLATier;
import com.aeontronix.enhancedmule.tools.anypoint.api.SLATierLimits;
import com.aeontronix.enhancedmule.tools.anypoint.api.SLATierList;
import com.aeontronix.enhancedmule.tools.anypoint.api.policy.Policy;
import com.aeontronix.enhancedmule.tools.application.api.PolicyDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.SLATierCreateRequest;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class API
extends AnypointObject<Environment> {
    private static final Logger logger = LoggerFactory.getLogger(API.class);
    private String id;
    private String assetVersion;
    private String productVersion;
    private String environmentId;
    private String instanceLabel;
    private int order;
    private String masterOrganizationId;
    private String organizationId;
    private String groupId;
    private String assetId;
    private String autodiscoveryInstanceName;
    private APIEndpoint endpoint;
    private String endpointUri;

    public API() {
    }

    public API(Environment environment) {
        super(environment);
    }

    public String getUriPath() {
        if (this.parent != null) {
            return "/apimanager/api/v1/organizations/" + ((Organization)((Environment)this.parent).getParent()).getId() + "/environments/" + ((Environment)this.parent).getId() + "/apis/" + this.id;
        }
        if (this.organizationId != null && this.environmentId != null) {
            return "/apimanager/api/v1/organizations/" + this.organizationId + "/environments/" + this.environmentId + "/apis/" + this.id;
        }
        throw new IllegalStateException("Insufficient data available in api to build uri");
    }

    public void createPolicy(PolicyDescriptor policyDescriptor) throws HttpException {
        Map<String, Object> reqMap = this.jsonHelper.buildJsonMap().set("apiVersionId", this.id).set("configurationData", policyDescriptor.getConfigurationData()).set("pointcutData", policyDescriptor.getPointcutData()).set("policyTemplateId", policyDescriptor.getPolicyTemplateId()).set("groupId", policyDescriptor.getGroupId()).set("assetId", policyDescriptor.getAssetId()).set("assetVersion", policyDescriptor.getAssetVersion()).toMap();
        this.httpHelper.httpPost("/apimanager/api/v1/organizations/" + ((Organization)((Environment)this.getParent()).getParent()).getId() + "/environments/" + ((Environment)this.getParent()).getId() + "/apis/" + this.id + "/policies", reqMap);
    }

    public APIContract requestAPIAccess(ClientApplication clientApplication) throws HttpException {
        return clientApplication.requestAPIAccess(this);
    }

    public APIContract requestAPIAccess(ClientApplication clientApplication, SLATier tier) throws HttpException {
        return clientApplication.requestAPIAccess(this, tier);
    }

    public APIContract findContract(ClientApplication clientApplication) throws HttpException, NotFoundException {
        for (APIContract contract : this.findContracts()) {
            if (!contract.getApplicationId().equals(clientApplication.getId())) continue;
            return contract;
        }
        throw new NotFoundException();
    }

    public SLATierList findSLATiers() throws HttpException {
        return new SLATierList(this);
    }

    public SLATier findSLATier(@NotNull String name) throws HttpException, NotFoundException {
        for (SLATier slaTier : this.findSLATiers()) {
            if (!slaTier.getName().equals(name)) continue;
            return slaTier;
        }
        throw new NotFoundException();
    }

    public SLATier createSLATier(String name, String description, boolean autoApprove, List<SLATierLimits> limits) throws HttpException {
        String json = this.client.getHttpHelper().httpPost("https://anypoint.mulesoft.com/apimanager/api/v1/organizations/" + ((Organization)((Environment)this.parent).getParent()).getId() + "/environments/" + ((Environment)this.parent).getId() + "/apis/" + this.id + "/tiers", new SLATierCreateRequest(this, name, description, autoApprove, limits));
        return this.jsonHelper.readJson(new SLATier(this), json);
    }

    public void updateImplementationUrl(String implementationUrl, boolean mule4, Type type) throws HttpException {
        this.updateImplementationUrl(API.createImplementationUrlJson(mule4, implementationUrl, type));
    }

    public void updateImplementationUrl(Map<String, Object> consumerUrlJson) throws HttpException {
        HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();
        data.put("endpoint", consumerUrlJson);
        ((Environment)this.parent).getClient().getHttpHelper().httpPatch(this.getUrl(), data);
    }

    public static API create(@NotNull Environment environment, @NotNull APISpec apiSpec, boolean mule4, @Nullable String implementationUrl, String consumerUrl, @Nullable String label, @NotNull Type type) throws HttpException {
        HashMap<String, Object> implementationUrlJson = API.createImplementationUrlJson(mule4, consumerUrl, type);
        return API.create(environment, apiSpec, label, implementationUrlJson, implementationUrl);
    }

    @NotNull
    private static HashMap<String, Object> createImplementationUrlJson(boolean mule4, @Nullable String endpointUrl, @NotNull Type type) {
        HashMap<String, Object> endpointJson = new HashMap<String, Object>();
        endpointJson.put("type", type.name().toLowerCase());
        endpointJson.put("uri", endpointUrl);
        endpointJson.put("proxyUri", null);
        endpointJson.put("isCloudHub", null);
        endpointJson.put("deploymentType", "CH");
        endpointJson.put("referencesUserDomain", null);
        endpointJson.put("responseTimeout", null);
        endpointJson.put("muleVersion4OrAbove", mule4);
        return endpointJson;
    }

    public static API create(@NotNull Environment environment, @NotNull APISpec apiSpec, @Nullable String label, Map<String, Object> implementationUrlJson, String consumerUrl) throws HttpException {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("instanceLabel", label);
        HashMap<String, String> specMap = new HashMap<String, String>();
        specMap.put("assetId", apiSpec.getAssetId());
        specMap.put("version", apiSpec.getVersion());
        specMap.put("groupId", apiSpec.getGroupId());
        req.put("spec", specMap);
        if (consumerUrl != null) {
            req.put("endpointUrl", consumerUrl);
        }
        if (implementationUrlJson != null) {
            req.put("endpoint", implementationUrlJson);
        }
        String json = environment.getClient().getHttpHelper().httpPost("/apimanager/api/v1/organizations/" + ((Organization)environment.getParent()).getId() + "/environments/" + environment.getId() + "/apis", req);
        return environment.getClient().getJsonHelper().readJson(new API(environment), json);
    }

    public API refresh() throws HttpException {
        return ((Environment)this.parent).findAPIById(this.id);
    }

    public List<Policy> findPolicies() throws HttpException {
        String json = ((Environment)this.parent).getClient().getHttpHelper().httpGet(this.getUrl() + "/policies?fullInfo=false");
        JsonHelper jsonHelper = ((Environment)this.parent).getClient().getJsonHelper();
        return jsonHelper.readJsonList(Policy.class, json, this);
    }

    @NotNull
    public String getUrl() {
        return "/apimanager/api/v1/organizations/" + ((Organization)((Environment)this.getParent()).getParent()).getId() + "/environments/" + ((Environment)this.getParent()).getId() + "/apis/" + this.id;
    }

    public Policy findPolicyByAsset(String groupId, String assetId, String assetVersion) throws HttpException, NotFoundException {
        for (Policy policy : this.findPolicies()) {
            if (!policy.getGroupId().equalsIgnoreCase(groupId) || !policy.getAssetId().equalsIgnoreCase(assetId) || !policy.getAssetVersion().equalsIgnoreCase(assetVersion)) continue;
            return policy;
        }
        throw new NotFoundException("Policy not found");
    }

    public APIContractList findContracts() throws HttpException {
        return new APIContractList(this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAssetVersion() {
        return this.assetVersion;
    }

    public void setAssetVersion(String assetVersion) {
        this.assetVersion = assetVersion;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public String getInstanceLabel() {
        return this.instanceLabel;
    }

    public void setInstanceLabel(String instanceLabel) {
        this.instanceLabel = instanceLabel;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getMasterOrganizationId() {
        return this.masterOrganizationId;
    }

    public void setMasterOrganizationId(String masterOrganizationId) {
        this.masterOrganizationId = masterOrganizationId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public String getAutodiscoveryInstanceName() {
        return this.autodiscoveryInstanceName;
    }

    public void setAutodiscoveryInstanceName(String autodiscoveryInstanceName) {
        this.autodiscoveryInstanceName = autodiscoveryInstanceName;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public APIEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(APIEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void delete() throws HttpException {
        this.httpHelper.httpHardDelete(this.getUrl());
    }

    public void deletePolicies() throws HttpException {
        for (Policy policy : this.findPolicies()) {
            policy.delete();
        }
    }

    public API updateVersion(String version) throws HttpException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("assetVersion", version);
        String json = ((Environment)this.parent).getClient().getHttpHelper().httpPatch(this.getUrl(), data);
        JsonHelper jsonHelper = ((Environment)this.parent).getClient().getJsonHelper();
        return jsonHelper.readJson(new API((Environment)this.parent), json, this.parent);
    }

    public String toString() {
        return "API{id='" + this.id + '\'' + ", assetVersion='" + this.assetVersion + '\'' + ", productVersion='" + this.productVersion + '\'' + ", environmentId='" + this.environmentId + '\'' + ", instanceLabel='" + this.instanceLabel + '\'' + ", order=" + this.order + ", masterOrganizationId='" + this.masterOrganizationId + '\'' + ", organizationId='" + this.organizationId + '\'' + ", groupId='" + this.groupId + '\'' + ", assetId='" + this.assetId + '\'' + ", autodiscoveryInstanceName='" + this.autodiscoveryInstanceName + '\'' + ", endpoint=" + this.endpoint + ", endpointUri='" + this.endpointUri + '\'' + '}';
    }

    public static enum Type {
        REST,
        HTTP;

    }
}

