/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.application.deploy;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.application.DeploymentException;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.DeploymentOperation;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.RuntimeDeploymentRequest;
import com.aeontronix.enhancedmule.tools.application.deployment.CloudhubDeploymentParameters;
import com.aeontronix.enhancedmule.tools.application.deployment.DeploymentParameters;
import com.aeontronix.enhancedmule.tools.cloudhub.CHMuleVersion;
import com.aeontronix.enhancedmule.tools.cloudhub.CHWorkerType;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.runtime.CHApplication;
import com.aeontronix.enhancedmule.tools.runtime.CHDeploymentResult;
import com.aeontronix.enhancedmule.tools.runtime.DeploymentResult;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.HttpHelper;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.aeontronix.enhancedmule.tools.util.StreamSource;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHDeploymentOperation
extends DeploymentOperation {
    private static final Logger logger = LoggerFactory.getLogger(CHDeploymentOperation.class);
    private static final EMTLogger elogger = new EMTLogger(logger);
    private int workerCount;
    private CHMuleVersion muleVersion;
    private String region;
    private CHWorkerType workerType;

    public CHDeploymentOperation(RuntimeDeploymentRequest req, Environment environment, ApplicationSource source) {
        super(req, environment, source);
    }

    @Override
    protected DeploymentResult doDeploy(RuntimeDeploymentRequest request) throws IOException, HttpException, DeploymentException {
        try {
            String deploymentJson;
            long start = System.currentTimeMillis();
            DeploymentParameters deploymentParameters = request.getApplicationDescriptor().getDeploymentParams();
            CloudhubDeploymentParameters cloudhub = request.getApplicationDescriptor().getDeploymentParams().getCloudhub();
            try {
                this.muleVersion = StringUtils.isBlank((String)cloudhub.getMuleVersion()) ? this.environment.findDefaultCHMuleVersion() : this.environment.findCHMuleVersion(cloudhub.getMuleVersion());
            }
            catch (NotFoundException e) {
                throw new DeploymentException(e);
            }
            this.region = StringUtils.isBlank((String)cloudhub.getRegion()) ? this.environment.findDefaultCHRegion().getId() : cloudhub.getRegion();
            this.workerType = StringUtils.isBlank((String)cloudhub.getWorkerType()) ? this.environment.findSmallestWorkerType() : this.environment.findWorkerTypeByName(cloudhub.getWorkerType());
            this.workerCount = cloudhub.getWorkerCount() == null || cloudhub.getWorkerCount() < 1 ? 1 : cloudhub.getWorkerCount();
            AnypointClient client = this.environment.getClient();
            HttpHelper httpHelper = client.getHttpHelper();
            JsonHelper.MapBuilder appInfoBuilder = client.getJsonHelper().buildJsonMap();
            Boolean extMonitoring = deploymentParameters.getExtMonitoring();
            if (extMonitoring == null || extMonitoring.booleanValue()) {
                this.deploymentRequest.setProperty("anypoint.platform.config.analytics.agent.enabled", "true");
            }
            String appName = request.getAppName();
            CHApplication existingApp = this.getExistingApp(appName);
            this.deploymentRequest.mergeExistingProperties(existingApp);
            appInfoBuilder.set("properties", this.deploymentRequest.getProperties()).set("domain", appName).set("monitoringEnabled", true).set("monitoringAutoRestart", true).set("loggingNgEnabled", true).set("objectStoreV1", cloudhub.getObjectStoreV1()).set("persistentQueues", cloudhub.getPersistentQueues()).set("persistentQueuesEncrypted", cloudhub.getPersistentQueuesEncrypted()).set("region", this.region).set("staticIPsEnabled", cloudhub.getStaticIPs()).set("loggingCustomLog4JEnabled", cloudhub.getCustomlog4j());
            appInfoBuilder.addMap("muleVersion").set("version", this.muleVersion.getVersion()).set("updateId", this.muleVersion.getLatestUpdate().getId());
            appInfoBuilder.addMap("workers").set("amount", this.workerCount).addMap("type").set("name", this.workerType.getName()).set("weight", this.workerType.getWeight()).set("cpu", this.workerType.getCpu()).set("memory", this.workerType.getMemory());
            appInfoBuilder.set("fileName", this.deploymentRequest.getFilename());
            Map<String, Object> appInfo = appInfoBuilder.toMap();
            elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Deploying cloudhub application", new Object[0]);
            elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Domain: " + appName, new Object[0]);
            elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Region: " + this.region, new Object[0]);
            elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Worker Count: " + this.workerCount, new Object[0]);
            elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Worker Type: " + this.workerType.getName(), new Object[0]);
            elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Mule Version: " + this.muleVersion.getVersion(), new Object[0]);
            elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Custom Log4J logging: " + (cloudhub.getCustomlog4j() != false ? "Yes" : "No"), new Object[0]);
            elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Static IPs: " + (cloudhub.getStaticIPs() != false ? "Yes" : "No"), new Object[0]);
            if (this.source.getLocalFile() != null) {
                HttpHelper.MultiPartRequest req;
                if (existingApp != null) {
                    req = httpHelper.createAnypointMultiPartPutRequest("/cloudhub/api/v2/applications/" + existingApp.getDomain(), this.environment);
                } else {
                    req = httpHelper.createAnypointMultiPartPostRequest("/cloudhub/api/v2/applications", this.getEnvironment());
                    req = req.addText("autoStart", "true");
                }
                String appInfoJson = new String(this.environment.getClient().getJsonHelper().toJson(appInfo));
                req = req.addText("appInfoJson", appInfoJson);
                logger.debug("Deployment JSON: {}", (Object)appInfoJson);
                req = req.addBinary("file", new StreamSource(){

                    @Override
                    public String getFileName() {
                        return CHDeploymentOperation.this.deploymentRequest.getFilename();
                    }

                    @Override
                    public InputStream createInputStream() throws IOException {
                        return new FileInputStream(CHDeploymentOperation.this.source.getLocalFile());
                    }
                });
                elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Uploading application archive to Cloudhub", new Object[0]);
                deploymentJson = req.execute();
                elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Application starting: " + appName, new Object[0]);
            } else {
                HashMap<String, Object> deployJson = new HashMap<String, Object>();
                deployJson.put("applicationInfo", appInfo);
                deployJson.put("applicationSource", this.source.getSourceJson(client.getJsonHelper()));
                if (existingApp != null) {
                    deploymentJson = httpHelper.anypointHttpPut("/cloudhub/api/v2/applications/" + existingApp.getDomain(), deployJson, this.environment);
                } else {
                    deployJson.put("autoStart", true);
                    deploymentJson = httpHelper.anypointHttpPost("/cloudhub/api/v2/applications/", deployJson, this.environment);
                }
                elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Requested application start from exchange asset: " + appName, new Object[0]);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("File upload took " + TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start) + " seconds");
            }
            if (!(existingApp == null || existingApp.getStatus().equalsIgnoreCase("STARTED") && existingApp.getDeploymentUpdateStatus() == null)) {
                try {
                    existingApp.start();
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
            return new CHDeploymentResult(client.getJsonHelper().readJson(new CHApplication(), deploymentJson, this.environment));
        }
        catch (NotFoundException e) {
            throw new DeploymentException(e);
        }
    }

    private CHApplication getExistingApp(String appName) throws HttpException {
        try {
            logger.debug("Searching for pre-existing application named " + appName);
            CHApplication application = this.environment.findCHApplicationByDomain(appName);
            logger.debug("Found application named {}", (Object)appName);
            return application;
        }
        catch (NotFoundException e) {
            logger.debug("Couldn't find application named {}", (Object)appName);
            return null;
        }
    }

    @Override
    public String processAppName(String appName) {
        if (appName == null) {
            CloudhubDeploymentParameters cloudhub = this.deploymentRequest.getApplicationDescriptor().getDeploymentParams().getCloudhub();
            if (cloudhub.getAppNameSuffix() != null) {
                appName = this.deploymentRequest.getArtifactId() + cloudhub.getAppNameSuffix();
            } else {
                Environment environment = this.getEnvironment();
                if (!cloudhub.getAppNameSuffixNPOnly().booleanValue() || !Environment.Type.PRODUCTION.equals((Object)environment.getType())) {
                    appName = this.deploymentRequest.getArtifactId() + environment.getSuffix();
                }
            }
            if (cloudhub.getAppNamePrefix() != null) {
                appName = cloudhub.getAppNamePrefix() + appName;
            }
            return appName;
        }
        return appName;
    }
}

