/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli;

import com.aeontronix.enhancedmule.config.ConfigCredentials;
import com.aeontronix.enhancedmule.config.CredentialsBearerTokenImpl;
import com.aeontronix.enhancedmule.config.CredentialsClientCredentialsImpl;
import com.aeontronix.enhancedmule.config.CredentialsUsernamePasswordImpl;
import picocli.CommandLine;

public class CredentialsArgs {
    @CommandLine.Option(names={"-upw", "--username-password"}, description={"Username / Password credentials (first parameter is username, second is password)"}, arity="2")
    public String[] upw;
    @CommandLine.Option(names={"-bt", "--bearer"}, description={"Bearer token credentials"})
    public String bearer;
    @CommandLine.Option(names={"-cc", "--credential-credentials"}, description={"Credential Credentials  (first parameter is client id, second is client password)"}, arity="2")
    public String[] clientCreds;

    public ConfigCredentials getCredentials() {
        if (this.upw != null) {
            return new CredentialsUsernamePasswordImpl(this.upw[0], this.upw[1]);
        }
        if (this.bearer != null) {
            return new CredentialsBearerTokenImpl(this.bearer);
        }
        if (this.clientCreds != null) {
            return new CredentialsClientCredentialsImpl(this.clientCreds[0], this.clientCreds[1]);
        }
        return null;
    }
}

