/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.config;

import com.aeontronix.enhancedmule.config.ConfigCredentials;
import com.aeontronix.enhancedmule.config.ConfigProfile;
import com.aeontronix.enhancedmule.config.CredentialsClientCredentialsImpl;
import com.aeontronix.enhancedmule.tools.cli.EMTCli;
import com.aeontronix.enhancedmule.tools.cli.config.ConfigCmd;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="clientcreds", description={"Set connected apps client credentials authentication in configuration"})
public class ConfigSetCredsClientCredentialsCmd
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigSetCredsClientCredentialsCmd.class);
    @CommandLine.ParentCommand
    private ConfigCmd parent;
    @CommandLine.Parameters(description={"Client id"}, arity="1")
    private String clientId;
    @CommandLine.Parameters(description={"Client secret"}, arity="1")
    private String clientSecret;

    @Override
    public Integer call() throws Exception {
        EMTCli cli = this.parent.getCli();
        ConfigProfile profile = cli.getActiveProfile();
        profile.setCredentials((ConfigCredentials)new CredentialsClientCredentialsImpl(this.clientId, this.clientSecret));
        cli.saveConfig();
        logger.info("Credentials updated");
        return 0;
    }
}

