/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.authentication;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.anypoint.authentication.AuthenticationProvider;
import com.aeontronix.enhancedmule.tools.util.AnypointAccessToken;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.HttpHelper;
import com.aeontronix.restclient.RESTClient;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.RESTRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AuthenticationProviderConnectedAppsImpl
extends AuthenticationProvider {
    private String clientId;
    private String clientSecret;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public AuthenticationProviderConnectedAppsImpl(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    public AnypointAccessToken getBearerToken(HttpHelper httpHelper) throws HttpException {
        try {
            if (StringUtils.isBlank((String)this.clientId)) {
                throw new IllegalArgumentException("Client ID is missing");
            }
            if (StringUtils.isBlank((String)this.clientSecret)) {
                throw new IllegalArgumentException("Client Secret is missing");
            }
            HashMap<String, String> request = new HashMap<String, String>();
            request.put("client_id", this.clientId);
            request.put("client_secret", this.clientSecret);
            request.put("grant_type", "client_credentials");
            httpHelper.setLoginRequest(true);
            Map data = (Map)this.objectMapper.readValue(httpHelper.httpPost("/accounts/api/v2/oauth2/token", request), Map.class);
            return new AnypointAccessToken((String)data.get("access_token"));
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public String filterSecret(String resStr) {
        return resStr.replace(this.clientSecret, "**********");
    }

    public boolean isRefreshRequired() {
        return false;
    }

    public boolean isRefreshable() {
        return false;
    }

    public void applyCredentials(RESTRequest request) {
        throw new RuntimeException("Not implemented (don't use connected app client_credentials it has severe limitations)");
    }

    public void refreshCredential(RESTClient restClient) throws RESTException {
        throw new RuntimeException("Not implemented (don't use connected app client_credentials it has severe limitations)");
    }
}

