/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.provisioning;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.ThreadUtils;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ProvisioningException;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ProvisioningScope;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.RolePermissionDescriptor;
import com.aeontronix.enhancedmule.tools.role.Role;
import com.aeontronix.enhancedmule.tools.role.RoleAssignmentAddition;
import com.aeontronix.enhancedmule.tools.role.RoleGroup;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.MarkdownHelper;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(RoleDescriptor.class);
    private String id;
    private String name;
    private String description;
    private Set<String> externalNames;
    private List<RolePermissionDescriptor> permissions;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(required=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotNull
    public Set<String> getExternalNames() {
        if (this.externalNames == null) {
            this.externalNames = new HashSet<String>();
        }
        return this.externalNames;
    }

    public void setExternalNames(@NotNull Set<String> externalNames) {
        this.externalNames = externalNames;
    }

    @NotNull
    public List<RolePermissionDescriptor> getPermissions() {
        if (this.permissions == null) {
            this.permissions = new ArrayList<RolePermissionDescriptor>();
        }
        return this.permissions;
    }

    public void setPermissions(@NotNull List<RolePermissionDescriptor> permissions) {
        this.permissions = permissions;
    }

    public void provision(Organization org, ArrayList<Environment> envs) throws ProvisioningException, HttpException {
        block14: {
            try {
                RoleGroup roleGroup2;
                if (StringUtils.isBlank((String)this.name)) {
                    throw new ProvisioningException("role name missing");
                }
                List roleGroups = org.findAllRoleGroups().getAll();
                Optional<RoleGroup> roleGroupOpt = roleGroups.stream().filter(roleGroup -> roleGroup.getName().equalsIgnoreCase(this.name)).findFirst();
                if (!roleGroupOpt.isPresent()) {
                    roleGroup2 = org.createRoleGroup(this.name, this.description);
                } else {
                    roleGroup2 = roleGroupOpt.get();
                    if (!roleGroup2.same(this)) {
                        roleGroup2.setDescription(this.description);
                        roleGroup2.setExternalNames(this.externalNames);
                        roleGroup2.update();
                    }
                }
                if (!roleGroup2.isEditable()) break block14;
                do {
                    roleGroup2.deleteAllRoleAssignment();
                    ThreadUtils.sleep((long)1000L);
                } while (roleGroup2.findRoleAssignments().size() > 0);
                if (this.permissions == null || this.permissions.isEmpty()) break block14;
                Map<String, Role> roles = ((Organization)roleGroup2.getParent()).findAllRolesIndexedByName();
                HashSet<RoleAssignmentAddition> assignments = new HashSet<RoleAssignmentAddition>();
                for (RolePermissionDescriptor permission : this.permissions) {
                    Role role = roles.get(permission.getName());
                    if (role == null) {
                        throw new ProvisioningException("Role not found: " + permission.getName());
                    }
                    List<ProvisioningScope> scopes = permission.getScopes();
                    if (!scopes.isEmpty()) {
                        for (ProvisioningScope scope : scopes) {
                            for (Environment matchEnvironment : scope.matchEnvironments(envs)) {
                                logger.debug("Assigning role " + role.getName() + " with env " + matchEnvironment.getName() + " to " + roleGroup2.getName());
                                assignments.add(new RoleAssignmentAddition(role.getId(), matchEnvironment));
                            }
                        }
                        continue;
                    }
                    logger.debug("Assigning role " + role.getName() + " to " + roleGroup2.getName());
                    assignments.add(new RoleAssignmentAddition(role.getId(), null));
                }
                try {
                    roleGroup2.assignRoles(assignments);
                    assignments.clear();
                }
                catch (HttpException | RuntimeException e) {
                    logger.error("Failed to assign roles to " + roleGroup2.getName() + " : " + assignments);
                    throw e;
                }
            }
            catch (NotFoundException e) {
                throw new ProvisioningException(e);
            }
        }
    }

    public void toMarkdown(Writer w, int headingDepth) throws IOException {
        MarkdownHelper.writeHeader(w, headingDepth + 2, this.getName());
        if (StringUtils.isNotEmpty((String)this.getDescription())) {
            MarkdownHelper.writeParagraph(w, "Description: " + this.getDescription());
        }
        if (!this.getExternalNames().isEmpty()) {
            MarkdownHelper.writeParagraph(w, "Mapped to SSO Roles: " + String.join((CharSequence)", ", this.getExternalNames()));
        }
        if (!this.getPermissions().isEmpty()) {
            MarkdownHelper.writeParagraph(w, "Permissions:");
        }
        for (RolePermissionDescriptor permission : this.getPermissions()) {
            StringBuilder perms = new StringBuilder();
            perms.append("- ").append(permission.getName());
            if (!permission.getScopes().isEmpty()) {
                List scopes = permission.getScopes().stream().map(ProvisioningScope::toShortMarkdown).collect(Collectors.toList());
                perms.append(" for environment");
                if (scopes.size() > 1) {
                    perms.append("s");
                }
                perms.append(": ").append(String.join((CharSequence)", ", scopes));
            }
            MarkdownHelper.writeParagraph(w, perms.toString());
        }
    }
}

