/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli;

import com.aeontronix.enhancedmule.config.ConfigCredentials;
import com.aeontronix.enhancedmule.config.ConfigProfile;
import com.aeontronix.enhancedmule.config.EMConfig;
import com.aeontronix.enhancedmule.config.ProfileNotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.cli.AbstractCommand;
import com.aeontronix.enhancedmule.tools.cli.CredentialsArgs;
import com.aeontronix.enhancedmule.tools.cli.LoginCmd;
import com.aeontronix.enhancedmule.tools.cli.UserInfoCmd;
import com.aeontronix.enhancedmule.tools.cli.application.ApplicationCmd;
import com.aeontronix.enhancedmule.tools.cli.config.ActiveProfileCmd;
import com.aeontronix.enhancedmule.tools.cli.config.ConfigCmd;
import com.aeontronix.enhancedmule.tools.cli.crypto.DecryptCmd;
import com.aeontronix.enhancedmule.tools.cli.crypto.EncryptCmd;
import com.aeontronix.enhancedmule.tools.cli.crypto.KeyGenCmd;
import com.aeontronix.enhancedmule.tools.emclient.EnhancedMuleClient;
import com.aeontronix.enhancedmule.tools.util.CredentialsConverter;
import com.aeontronix.enhancedmule.tools.util.VersionHelper;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jline.reader.LineReader;
import picocli.CommandLine;

@CommandLine.Command(name="emt", subcommands={ApplicationCmd.class, ConfigCmd.class, KeyGenCmd.class, EncryptCmd.class, DecryptCmd.class, ActiveProfileCmd.class, LoginCmd.class, UserInfoCmd.class}, versionProvider=VersionHelper.class, mixinStandardHelpOptions=true)
public class EMTCli
extends AbstractCommand {
    @CommandLine.Option(names={"--version"}, versionHelp=true, description={"display version info"})
    boolean versionInfoRequested;
    @CommandLine.Option(names={"-d", "--debug"}, description={"Enable debug"})
    private boolean debug;
    @CommandLine.Option(names={"-p"}, description={"Profile"})
    private String profileName;
    private File workDir = new File(".");
    private LineReader reader;
    @CommandLine.ArgGroup(exclusive=false, multiplicity="0..1")
    private CredentialsArgs credentialsArgs;
    private EMConfig config = EMConfig.findConfigFile();
    private ConfigProfile activeProfile = this.profileName != null ? this.config.getProfileByProfileName(this.profileName) : this.config.getProfile(null, null, null);

    @Override
    public EMTCli getCli() {
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public EMConfig getConfig() {
        return this.config;
    }

    public boolean isShell() {
        return this.reader != null;
    }

    public LineReader getReader() {
        return this.reader;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void setReader(LineReader reader) {
        this.reader = reader;
    }

    @NotNull
    public ConfigProfile getActiveProfile() throws IOException, ProfileNotFoundException {
        return this.activeProfile;
    }

    @NotNull
    public String getActiveProfileId() throws IOException, ProfileNotFoundException {
        return this.profileName != null ? this.profileName : this.config.getActive();
    }

    public void saveConfig() throws IOException {
        this.config.save();
    }

    public Environment getEnvironment(String organizationName, String environmentName) throws IOException, ProfileNotFoundException, NotFoundException {
        if (organizationName == null) {
            organizationName = this.getActiveProfile().getDefaultOrg();
        }
        if (environmentName == null) {
            environmentName = this.getActiveProfile().getDefaultEnv();
        }
        if (organizationName == null) {
            throw new IllegalArgumentException("Organization not set and no default is assigned in profile");
        }
        if (environmentName == null) {
            throw new IllegalArgumentException("Environment not set and no default is assigned in profile");
        }
        EnhancedMuleClient client = this.getClient(organizationName, environmentName);
        client.getAnypointClient().findEnvironment(organizationName, environmentName, false, false, null);
        return null;
    }

    public EnhancedMuleClient getClient() throws IOException, ProfileNotFoundException {
        return this.getClient(null, null);
    }

    public EnhancedMuleClient getClient(String organizationName, String environmentName) throws IOException, ProfileNotFoundException {
        ConfigCredentials credentials;
        ConfigCredentials configCredentials = credentials = this.credentialsArgs != null ? this.credentialsArgs.getCredentials() : null;
        if (credentials == null) {
            credentials = this.getActiveProfile().getCredentials();
        }
        if (credentials == null) {
            throw new IllegalArgumentException("No credentials available");
        }
        EnhancedMuleClient enhancedMuleClient = new EnhancedMuleClient(this.getActiveProfile());
        enhancedMuleClient.setCredentialsLoader(CredentialsConverter.convert(credentials));
        return enhancedMuleClient;
    }

    public Organization findOrganization(String organization) throws IOException, ProfileNotFoundException, NotFoundException {
        if (organization != null) {
            return this.getClient(organization, null).getAnypointClient().findOrganizationByNameOrId(organization);
        }
        AnypointClient anypointClient = this.getClient().getAnypointClient();
        Organization org = anypointClient.getUser().getOrganization();
        org.setClient(anypointClient);
        return org;
    }
}

