/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.application;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.file.FileUtils;
import com.aeontronix.commons.file.TempFile;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetFile;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAsset;
import com.aeontronix.enhancedmule.tools.cli.application.ApplicationCmd;
import com.aeontronix.enhancedmule.tools.util.VersionHelper;
import com.aeontronix.genesis.ResourceLoader;
import com.aeontronix.genesis.Template;
import com.aeontronix.genesis.TemplateExecutionException;
import com.aeontronix.genesis.TemplateExecutor;
import com.aeontronix.genesis.ZipResourceLoader;
import com.aeontronix.restclient.RESTResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="create")
public class ApplicationCreateCmd
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationCreateCmd.class);
    public static final String EMT_VERSION_KEY = "emtVersion";
    public static final String TEMPLATE_FILE = "genesis-template.json";
    @CommandLine.Option(names={"-D"}, description={"Template variables"})
    private HashMap<String, String> vars = new HashMap();
    @CommandLine.Option(names={"-o"}, description={"Organization name or id"})
    private String organization;
    @CommandLine.Option(names={"-i"}, description={"Template asset id"})
    private String templateAssetId = "emt-application-template";
    @CommandLine.Parameters(description={"Project directory"})
    private File dir;
    @CommandLine.ParentCommand
    private ApplicationCmd applicationCmd;

    public ApplicationCmd getApplicationCmd() {
        return this.applicationCmd;
    }

    @Override
    public Integer call() throws Exception {
        if (!this.vars.containsKey(EMT_VERSION_KEY)) {
            this.vars.put(EMT_VERSION_KEY, VersionHelper.EMT_VERSION);
        }
        Organization org = this.getApplicationCmd().getCli().findOrganization(this.organization);
        Template template = null;
        try {
            ExchangeAsset exchangeAsset = org.findExchangeAsset(org.getId(), this.templateAssetId);
            Optional<AssetFile> file = exchangeAsset.getFiles().stream().filter(f -> "custom".equalsIgnoreCase(f.getClassifier())).findFirst();
            AssetFile assetFile = file.orElseThrow(() -> new RuntimeException("Asset is a not an EMT template"));
            try (TempFile tempFile = new TempFile("emttemplate");){
                try (RESTResponse response = org.getClient().getRestClient().get(URI.create(assetFile.getExternalLink())).execute();
                     FileOutputStream fos = new FileOutputStream((File)tempFile);){
                    IOUtils.copy((InputStream)response.getContentStream(), (OutputStream)fos);
                }
                template = Template.loadTemplate((ResourceLoader)new ZipResourceLoader((File)tempFile));
                template.setResourcePath("/");
                this.execute(template);
            }
        }
        catch (NotFoundException e) {
            logger.warn("Exchange template not found, using built-in");
            template = Template.createFromClasspath((String)"/template", (String)TEMPLATE_FILE);
            this.execute(template);
        }
        return 0;
    }

    private void execute(Template template) throws TemplateExecutionException {
        TemplateExecutor templateExecutor = new TemplateExecutor(template);
        templateExecutor.setVariables(this.vars);
        templateExecutor.execute(this.dir);
    }

    public static void unzip(File zipFile, File destDir) throws IOException {
        logger.info("Unzipping archive");
        if (!destDir.exists()) {
            FileUtils.mkdirs((File)destDir);
        }
        try (FileInputStream fis = new FileInputStream(zipFile);){
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName().replaceFirst(".*?/", "").replace("/", File.separator);
                boolean valid = StringUtils.isNotBlank((String)fileName);
                if (valid) {
                    File newFile = new File(destDir + File.separator + fileName);
                    if (ze.isDirectory()) {
                        if (!newFile.exists()) {
                            FileUtils.mkdirs((File)newFile);
                        }
                    } else {
                        File parent = newFile.getParentFile();
                        if (!parent.exists()) {
                            FileUtils.mkdirs((File)parent);
                        }
                        try (FileOutputStream fos = new FileOutputStream(newFile);){
                            IOUtils.copy((InputStream)zis, (OutputStream)fos);
                        }
                    }
                    zis.closeEntry();
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
    }
}

