/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.config;

import com.aeontronix.enhancedmule.config.ConfigProfile;
import com.aeontronix.enhancedmule.tools.cli.EMTCli;
import com.aeontronix.enhancedmule.tools.cli.config.ConfigCmd;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="env", description={"Set default environment in configuration"})
public class ConfigSetEnvCmd
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigSetEnvCmd.class);
    @CommandLine.ParentCommand
    private ConfigCmd configCmd;
    @CommandLine.Parameters(description={"Default environment name or id"}, arity="1")
    private String env;

    @Override
    public Integer call() throws Exception {
        EMTCli cli = this.configCmd.getCli();
        ConfigProfile profile = cli.getActiveProfile();
        profile.setDefaultEnv(this.env);
        cli.saveConfig();
        logger.info("Default environment set to " + this.env);
        return 0;
    }
}

