/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.exchange;

import com.aeontronix.commons.URLBuilder;
import com.aeontronix.enhancedmule.tools.util.restclient.RESTClient;
import com.aeontronix.enhancedmule.tools.util.restclient.ResponseStream;
import java.io.IOException;

public class ExchangeClient {
    public static final String MAVENBASEPATH = "/api/v2/maven";
    private RESTClient restClient;
    private String exchangeMavenUrl;

    public ExchangeClient(RESTClient restClient, String exchangeMavenUrl) {
        this.restClient = restClient;
        this.exchangeMavenUrl = exchangeMavenUrl;
    }

    public ResponseStream getAsset(String groupId, String artifactId, String version, String classifier, String extension) throws IOException {
        StringBuilder filename = new StringBuilder(artifactId).append('-').append(version);
        if (classifier != null) {
            filename.append('-').append(classifier);
        }
        filename.append('.').append(extension);
        String url = new URLBuilder(this.exchangeMavenUrl).path(MAVENBASEPATH).path(groupId).path(artifactId).path(version).path(filename.toString()).toString();
        return this.restClient.get(url).executeReturnStream();
    }

    public ResponseStream getAsset(String path) throws IOException {
        return this.restClient.get(new URLBuilder(this.exchangeMavenUrl).path(MAVENBASEPATH).path(path).toString()).executeReturnStream();
    }
}

