/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.util.restclient;

import com.aeontronix.commons.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.jetbrains.annotations.NotNull;

public class ResponseStream
extends InputStream {
    private final InputStream content;
    private final long contentLength;
    private CloseableHttpResponse response;
    private long lastModified = 0L;

    public ResponseStream(CloseableHttpResponse response) throws IOException {
        this.response = response;
        HttpEntity entity = response.getEntity();
        Header lastModifiedHeader = response.getLastHeader("last-modified");
        if (lastModifiedHeader != null && lastModifiedHeader.getValue() != null) {
            this.lastModified = Long.parseLong(lastModifiedHeader.getValue());
        }
        this.contentLength = response.getEntity().getContentLength();
        this.content = entity.getContent();
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public int read() throws IOException {
        return this.content.read();
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        return this.content.read(b);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        return this.content.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.content.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.content.available();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Object[])new Object[]{this.content, this.response});
    }

    @Override
    public void mark(int readlimit) {
        this.content.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.content.reset();
    }

    @Override
    public boolean markSupported() {
        return this.content.markSupported();
    }
}

