/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.URLBuilder;
import com.aeontronix.commons.UUIDFactory;
import com.aeontronix.enhancedmule.config.ConfigCredentials;
import com.aeontronix.enhancedmule.config.CredentialsBearerTokenImpl;
import com.aeontronix.enhancedmule.tools.cli.AbstractCommand;
import com.aeontronix.enhancedmule.tools.cli.EMTCli;
import com.aeontronix.enhancedmule.tools.util.MavenHelper;
import com.aeontronix.kryptotek.DigestUtils;
import com.aeontronix.restclient.RESTClient;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="login", description={"Login to server"})
public class LoginCmd
extends AbstractCommand
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(LoginCmd.class);
    public static final Pattern codeMatcher = Pattern.compile("code=(.*?)&");
    @CommandLine.Option(names={"-ss", "--skip-maven-settings-update"}, description={"If set to true, maven settings.xml will not be updated with bearer token"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private boolean updateSettingsXml;
    @CommandLine.Option(names={"-sf", "--maven-settings-file"}, description={"Maven settings.xml file location"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private File mavenSettingsFile = new File(System.getProperty("user.home") + File.separator + ".m2" + File.separator + "settings.xml");

    @Override
    public Integer call() throws Exception {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            String state = UUIDFactory.generate().toString();
            String verifier = UUIDFactory.generate().toString() + UUIDFactory.generate();
            String challenge = StringUtils.base64EncodeToString((byte[])DigestUtils.sha256((byte[])verifier.getBytes(StandardCharsets.US_ASCII)), (boolean)true);
            String redirectUrl = "http://localhost:" + serverSocket.getLocalPort() + "/";
            EMTCli cli = this.getCli();
            try (RESTClient restClient = RESTClient.builder().build();){
                String authServerBaseUrl = cli.getActiveProfile().getServerUrl();
                if (authServerBaseUrl == null) {
                    authServerBaseUrl = "https://auth.enhanced-mule.com";
                }
                Map oidcCfg = (Map)restClient.get(new URLBuilder(authServerBaseUrl).path("/.well-known/openid-configuration").toUri()).executeAndConvertToObject(Map.class);
                String authorizationEndpoint = (String)oidcCfg.get("authorization_endpoint");
                String tokenEndpoint = (String)oidcCfg.get("token_endpoint");
                URI authorizeUri = new URLBuilder(authorizationEndpoint).queryParam("redirect_uri", (Object)redirectUrl).queryParam("state", (Object)state).queryParam("code_challenge", (Object)challenge).queryParam("code_challenge_method", (Object)"S256").queryParam("scope", (Object)"full").toUri();
                logger.info("Authenticating request: " + authorizeUri);
                try {
                    Desktop.getDesktop().browse(authorizeUri);
                }
                catch (Exception e) {
                    logger.warn("Unable to launch browser, please manually open web browser and navigate to : " + authorizeUri);
                }
                try (Socket socket = serverSocket.accept();
                     BufferedReader r = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                     BufferedWriter w = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));){
                    String redirectTo;
                    String line = r.readLine();
                    HashMap<String, String> params = new HashMap<String, String>();
                    for (String str : URI.create(line.split(" ")[1]).getQuery().split("&")) {
                        String[] entry = str.split("=");
                        params.put(entry[0], StringUtils.urlDecode((String)entry[1]));
                    }
                    String code = (String)params.get("code");
                    String callbackState = (String)params.get("state");
                    if (!callbackState.equals(state)) {
                        throw new IllegalArgumentException("Received state does not match sent");
                    }
                    HashMap<String, String> req = new HashMap<String, String>();
                    req.put("grant_type", "authorization_code");
                    req.put("redirect_uri", redirectUrl);
                    req.put("code_verifier", verifier);
                    req.put("code", code);
                    Map tokens = (Map)restClient.post(tokenEndpoint).jsonBody(req).executeAndConvertToObject(Map.class);
                    String anAccessToken = (String)tokens.get("an_access_token");
                    cli.getActiveProfile().setCredentials((ConfigCredentials)new CredentialsBearerTokenImpl(anAccessToken));
                    cli.saveConfig();
                    if (!this.updateSettingsXml) {
                        MavenHelper.updateMavenSettings(this.mavenSettingsFile, cli.getActiveProfileId(), anAccessToken);
                    }
                    if ((redirectTo = (String)params.get("redirectTo")) != null) {
                        w.write("HTTP/1.1 302 Found\nContent-Type: text/html\nLocation: " + redirectTo + "\n\n");
                    } else {
                        w.append("HTTP/1.1 200 Ok\nContent-Type: text/html\n\n");
                        w.append("<html><body><center>");
                        w.append("Login successful, you can close this browser window");
                        w.append("</center></body></html>");
                    }
                }
            }
        }
        return 0;
    }
}

