/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.cloudhub.application;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.cloudhub.CHApplication;
import com.aeontronix.anypointsdk.cloudhub.CloudhubClient;
import com.aeontronix.enhancedmule.tools.cli.AbstractEnvCommand;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="download", description={"Download a cloudhub application"})
public class CHApplicationDownloadCmd
extends AbstractEnvCommand
implements Callable<Integer> {
    Logger logger = LoggerFactory.getLogger(CHApplicationDownloadCmd.class);
    @CommandLine.Parameters(arity="1", description={"Application id"})
    private String appDomain;
    @CommandLine.Option(names={"-f", "--file"}, description={"File to save the application as (if directory is specified, it will be saved in that directory with the original application filename)"}, defaultValue=".")
    private File file;

    @Override
    public Integer call() throws Exception {
        AnypointClient anypointClient = this.getCli().getAnypointClient();
        CloudhubClient cloudhubClient = anypointClient.getCloudhubClient();
        Optional chApplication = cloudhubClient.describeApplication(this.getOrgId(), this.getEnvId(), this.appDomain);
        String filename = ((CHApplication)chApplication.orElseThrow(() -> new IllegalStateException("Application not found"))).getFileName();
        if (this.file.isDirectory()) {
            this.file = new File(this.file, filename);
        }
        this.logger.info("Downloading application file to : " + this.file.getPath());
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
            cloudhubClient.downloadApplicationFile(this.getOrgId(), this.getEnvId(), this.appDomain, filename, (OutputStream)fileOutputStream);
        }
        this.logger.info("Downloading complete");
        return 0;
    }
}

