/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.config;

import com.aeontronix.enhancedmule.config.EMConfig;
import com.aeontronix.enhancedmule.tools.cli.EMTCli;
import java.util.concurrent.Callable;
import org.fusesource.jansi.Ansi;
import picocli.CommandLine;

@CommandLine.Command(name="profile", description={"Change or show active profile"})
public class ActiveProfileCmd
implements Callable<Integer> {
    @CommandLine.ParentCommand
    private EMTCli cli;
    @CommandLine.Option(names={"-c", "--create"}, description={"Create profile if required"})
    boolean create;
    @CommandLine.Parameters(arity="0..1", description={"profile to activate"})
    private String profile;

    @Override
    public Integer call() throws Exception {
        EMConfig config = this.cli.getConfig();
        if (this.profile != null) {
            if (this.create) {
                config.getOrCreateProfile(this.profile);
            } else {
                config.checkProfileExists(this.profile);
            }
            config.setActive(this.profile);
            config.getOrCreateProfile(this.profile);
            config.save();
        }
        System.out.println(Ansi.ansi().a("Active profile: " + config.getActive()));
        System.out.println("Available profiles: " + String.join((CharSequence)", ", config.getProfiles().keySet()));
        return 0;
    }
}

