/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.util;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.anypoint.InvalidJsonException;
import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JsonHelper
implements Serializable {
    private ObjectMapper jsonMapper = JsonHelper.createMapper();
    private LegacyAnypointClient client;

    public JsonHelper() {
    }

    public JsonHelper(LegacyAnypointClient client) {
        this.client = client;
    }

    public static void processVariables(ObjectNode json, HashMap<String, String> vars) {
        LinkedList<Object> nodes = new LinkedList<Object>();
        nodes.add(json);
        while (!nodes.isEmpty()) {
            JsonNode node = (JsonNode)nodes.removeFirst();
            if (node == null || node.isNull()) continue;
            if (node instanceof ObjectNode) {
                Iterator fields = node.fields();
                while (fields.hasNext()) {
                    Map.Entry field = (Map.Entry)fields.next();
                    JsonNode n = (JsonNode)field.getValue();
                    if (n instanceof TextNode) {
                        ((ObjectNode)node).replace((String)field.getKey(), (JsonNode)new TextNode(StringUtils.substituteVariables((String)n.textValue(), vars)));
                        continue;
                    }
                    if (n instanceof ArrayNode) {
                        for (JsonNode children : node) {
                            nodes.addLast(children);
                        }
                        continue;
                    }
                    if (!(n instanceof ObjectNode)) continue;
                    nodes.addLast(n);
                }
                continue;
            }
            if (!(node instanceof ArrayNode)) continue;
            int size = node.size();
            for (int i = 0; i < size; ++i) {
                JsonNode child = node.get(i);
                if (child instanceof TextNode) {
                    TextNode replacement = new TextNode(StringUtils.substituteVariables((String)child.textValue(), vars));
                    ((ArrayNode)node).remove(i);
                    ((ArrayNode)node).insert(i, (JsonNode)replacement);
                    continue;
                }
                nodes.addLast(child);
            }
            for (JsonNode children : node) {
                nodes.addLast(children);
            }
        }
    }

    public static Object getCaseInsensitive(ObjectNode node, String name) {
        Iterator names = node.fieldNames();
        while (names.hasNext()) {
            String n = (String)names.next();
            if (!n.equalsIgnoreCase(name)) continue;
            return node.get(n);
        }
        return null;
    }

    public LegacyAnypointClient getClient() {
        return this.client;
    }

    public void setClient(LegacyAnypointClient client) {
        this.client = client;
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public byte[] toJson(Object obj) {
        byte[] byArray;
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        try {
            this.jsonMapper.writeValue((OutputStream)tmp, obj);
            byArray = tmp.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    tmp.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        tmp.close();
        return byArray;
    }

    public Map<String, Object> toJsonMap(String json) {
        try {
            return (Map)this.jsonMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    public Map<String, Object> toJsonMap(JsonNode node) {
        try {
            return (Map)this.jsonMapper.treeToValue((TreeNode)node, Map.class);
        }
        catch (JsonProcessingException e) {
            throw new InvalidJsonException(e);
        }
    }

    public MapBuilder buildJsonMap() {
        return new MapBuilder();
    }

    public MapBuilder buildJsonMap(Map<String, Object> data) {
        return new MapBuilder(null, data);
    }

    public JsonNode readJsonTree(String json) {
        try {
            return this.jsonMapper.readTree(json);
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    public <X> X readJson(X obj, String json, String jsonPath) {
        try {
            return this.readJson(obj, this.jsonMapper.readerForUpdating(obj).readTree(json).at(jsonPath));
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    public <X> X readJson(X obj, String json) {
        return this.readJson(obj, json, (AnypointObject)null);
    }

    public <X> X readJson(X obj, String json, AnypointObject<?> parent) {
        try {
            this.jsonMapper.readerForUpdating(obj).readValue(json);
            if (obj instanceof AnypointObject) {
                ((AnypointObject)obj).setJson(json);
                if (parent != null) {
                    ((AnypointObject)obj).setParent(parent);
                }
            }
            return obj;
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    public <X> X readJson(Class<X> objClass, JsonNode node, AnypointObject<?> parent) {
        try {
            Object obj = this.jsonMapper.treeToValue((TreeNode)node, objClass);
            if (obj instanceof AnypointObject) {
                ((AnypointObject)obj).setJson(node.toString());
                ((AnypointObject)obj).setParent(parent);
            }
            return (X)obj;
        }
        catch (JsonProcessingException e) {
            throw new InvalidJsonException(e);
        }
    }

    public <X> X readJson(Class<X> objClass, JsonNode node, LegacyAnypointClient client) {
        try {
            Object obj = this.jsonMapper.treeToValue((TreeNode)node, objClass);
            if (obj instanceof AnypointObject) {
                ((AnypointObject)obj).setJson(node.toString());
                ((AnypointObject)obj).setClient(client);
            }
            return (X)obj;
        }
        catch (JsonProcessingException e) {
            throw new InvalidJsonException(e);
        }
    }

    public <X> List<X> readJsonList(Class<X> objClass, String json, AnypointObject<?> parent) {
        return this.readJsonList(objClass, json, parent, null);
    }

    public <X> List<X> readJsonList(Class<X> objClass, String json, AnypointObject<?> parent, String path) {
        try {
            ArrayList<X> list = new ArrayList<X>();
            JsonNode node = this.jsonMapper.readTree(json);
            if (path != null) {
                node = node.at(path);
            }
            for (JsonNode n : node) {
                list.add(this.readJson(objClass, n, parent));
            }
            return list;
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    public <X> X readJson(X obj, JsonNode node) {
        try {
            this.jsonMapper.readerForUpdating(obj).readValue(node);
            if (obj instanceof AnypointObject) {
                ((AnypointObject)obj).setJson(node.toString());
                ((AnypointObject)obj).setClient(this.client);
            }
            return obj;
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    public static ObjectMapper createMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.registerModule((Module)new JavaTimeModule());
        return objectMapper;
    }

    public static boolean isNull(JsonNode node) {
        return node == null || node.isNull();
    }

    public static boolean isNotNull(JsonNode node) {
        return !JsonHelper.isNull(node);
    }

    public static String getText(JsonNode node, String name) {
        JsonNode val;
        if (JsonHelper.isNotNull(node) && JsonHelper.isNotNull(val = node.get(name))) {
            return val.textValue();
        }
        return null;
    }

    public class MapBuilder {
        private MapBuilder parent;
        private Map<String, Object> request;

        public MapBuilder() {
            this.request = new HashMap<String, Object>();
        }

        public MapBuilder(MapBuilder parent, Map<String, Object> request) {
            this.parent = parent;
            this.request = request;
        }

        public MapBuilder set(String key, Object value) {
            this.request.put(key, value);
            return this;
        }

        public MapBuilder setNested(String nestKey, String key, Object value) {
            HashMap<String, Object> nestedMap = new HashMap<String, Object>();
            nestedMap.put(key, value);
            this.request.put(nestKey, nestedMap);
            return this;
        }

        public Map<String, Object> toMap() {
            if (this.parent != null) {
                return this.parent.toMap();
            }
            return this.request;
        }

        public MapBuilder addMap(String name) {
            HashMap<String, Object> subMap = new HashMap<String, Object>();
            this.request.put(name, subMap);
            return new MapBuilder(this, subMap);
        }
    }
}

