/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.exchange;

import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.api.SLATier;
import com.aeontronix.enhancedmule.tools.anypoint.api.SLATierNotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAsset;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import java.util.StringJoiner;

public class AssetInstance
extends AnypointObject<ExchangeAsset> {
    @JsonProperty
    private String versionGroup;
    @JsonProperty
    private String organizationId;
    @JsonProperty
    private String id;
    @JsonProperty
    private String groupId;
    @JsonProperty
    private String assetId;
    @JsonProperty
    private String productAPIVersion;
    @JsonProperty
    private String version;
    @JsonProperty
    private String environmentId;
    @JsonProperty
    private String endpointUri;
    @JsonProperty
    private String name;
    @JsonProperty
    private boolean isPublic;
    @JsonProperty
    private String type;
    @JsonProperty
    private String fullname;
    @JsonProperty
    private String assetName;

    public List<SLATier> findSLATiers() throws HttpException {
        String json = this.httpHelper.httpGet("https://anypoint.mulesoft.com/exchange/api/v1/organizations/" + ((Organization)((ExchangeAsset)this.getParent()).getParent()).getId() + "/assets/" + ((ExchangeAsset)this.getParent()).getGroupId() + "/" + ((ExchangeAsset)this.getParent()).getAssetId() + "/productApiVersion/" + ((ExchangeAsset)this.getParent()).getProductAPIVersion() + "/instances/" + this.id + "/tiers");
        try {
            return (List)this.jsonHelper.getJsonMapper().readValue(json, (TypeReference)new TypeReference<List<SLATier>>(){});
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public SLATier findSLATier(String name) throws HttpException, SLATierNotFoundException {
        for (SLATier tier : this.findSLATiers()) {
            if (!tier.getName().equalsIgnoreCase(name)) continue;
            return tier;
        }
        throw new SLATierNotFoundException("SLA Tier not found: " + name);
    }

    public String getVersionGroup() {
        return this.versionGroup;
    }

    public void setVersionGroup(String versionGroup) {
        this.versionGroup = versionGroup;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public String getProductAPIVersion() {
        return this.productAPIVersion;
    }

    public void setProductAPIVersion(String productAPIVersion) {
        this.productAPIVersion = productAPIVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean aPublic) {
        this.isPublic = aPublic;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public String toString() {
        return new StringJoiner(", ", AssetInstance.class.getSimpleName() + "[", "]").add("versionGroup='" + this.versionGroup + "'").add("organizationId='" + this.organizationId + "'").add("id='" + this.id + "'").add("groupId='" + this.groupId + "'").add("assetId='" + this.assetId + "'").add("productAPIVersion='" + this.productAPIVersion + "'").add("version='" + this.version + "'").add("environmentId='" + this.environmentId + "'").add("endpointUri='" + this.endpointUri + "'").add("name='" + this.name + "'").add("isPublic=" + this.isPublic).add("type='" + this.type + "'").add("fullname='" + this.fullname + "'").add("assetName='" + this.assetName + "'").toString();
    }
}

