/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.auth.AnypointClientCredentialsAuthenticationHandler;
import com.aeontronix.anypointsdk.auth.AnypointUPWAuthenticationHandler;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.cli.AbstractCommand;
import com.aeontronix.enhancedmule.tools.cli.CredentialsArgs;
import com.aeontronix.enhancedmule.tools.cli.LoginCmd;
import com.aeontronix.enhancedmule.tools.cli.UserInfoCmd;
import com.aeontronix.enhancedmule.tools.cli.apim.APIManagerCmd;
import com.aeontronix.enhancedmule.tools.cli.application.ApplicationCmd;
import com.aeontronix.enhancedmule.tools.cli.cloudhub.CloudhubCmd;
import com.aeontronix.enhancedmule.tools.cli.config.ActiveProfileCmd;
import com.aeontronix.enhancedmule.tools.cli.config.ConfigCmd;
import com.aeontronix.enhancedmule.tools.cli.crypto.DecryptCmd;
import com.aeontronix.enhancedmule.tools.cli.crypto.EncryptCmd;
import com.aeontronix.enhancedmule.tools.cli.crypto.KeyGenCmd;
import com.aeontronix.enhancedmule.tools.cli.exchange.ExchangeCmd;
import com.aeontronix.enhancedmule.tools.config.ConfigCredentials;
import com.aeontronix.enhancedmule.tools.config.ConfigProfile;
import com.aeontronix.enhancedmule.tools.config.CredentialsBearerTokenImpl;
import com.aeontronix.enhancedmule.tools.config.CredentialsClientCredentialsImpl;
import com.aeontronix.enhancedmule.tools.config.CredentialsUsernamePasswordImpl;
import com.aeontronix.enhancedmule.tools.config.EMConfig;
import com.aeontronix.enhancedmule.tools.config.ProfileNotFoundException;
import com.aeontronix.enhancedmule.tools.emclient.EnhancedMuleClient;
import com.aeontronix.enhancedmule.tools.util.CredentialsConverter;
import com.aeontronix.enhancedmule.tools.util.VersionHelper;
import com.aeontronix.restclient.auth.AuthenticationHandler;
import com.aeontronix.restclient.auth.BearerTokenAuthenticationHandler;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jline.reader.LineReader;
import picocli.CommandLine;

@CommandLine.Command(name="emt", subcommands={ConfigCmd.class, KeyGenCmd.class, EncryptCmd.class, DecryptCmd.class, ActiveProfileCmd.class, LoginCmd.class, UserInfoCmd.class, APIManagerCmd.class, ExchangeCmd.class, ApplicationCmd.class, CloudhubCmd.class}, versionProvider=VersionHelper.class, mixinStandardHelpOptions=true)
public class EMTCli
extends AbstractCommand {
    @CommandLine.Option(names={"--version"}, versionHelp=true, description={"display version info"})
    boolean versionInfoRequested;
    @CommandLine.Option(names={"-d", "--debug"}, description={"Enable debug"})
    private boolean debug;
    @CommandLine.Option(names={"-p"}, description={"Profile"})
    private String profileName;
    private File workDir = new File(".");
    private LineReader reader;
    @CommandLine.ArgGroup(exclusive=false, multiplicity="0..1")
    private CredentialsArgs credentialsArgs;
    @CommandLine.Option(names={"-u", "--base-url"}, description={"Anypoint base URL"})
    private URL anypointUrl;
    private EMConfig config = EMConfig.findConfigFile();
    private ConfigProfile activeProfile;
    private AnypointClient anypointClient;

    @Override
    public EMTCli getCli() {
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public EMConfig getConfig() {
        return this.config;
    }

    public boolean isShell() {
        return this.reader != null;
    }

    public LineReader getReader() {
        return this.reader;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void setReader(LineReader reader) {
        this.reader = reader;
    }

    @NotNull
    public ConfigProfile getActiveProfile() throws IOException, ProfileNotFoundException {
        if (this.activeProfile == null) {
            this.activeProfile = this.profileName != null ? this.config.getProfileByProfileName(this.profileName) : this.config.getProfile(null);
        }
        return this.activeProfile;
    }

    @NotNull
    public String getActiveProfileId() throws IOException, ProfileNotFoundException {
        return this.profileName != null ? this.profileName : this.config.getActive();
    }

    public void saveConfig() throws IOException {
        this.config.save();
    }

    public synchronized AnypointClient getAnypointClient() throws IOException, ProfileNotFoundException {
        if (this.anypointClient == null) {
            AuthenticationHandler authenticationHandler;
            if (this.credentialsArgs != null) {
                authenticationHandler = this.credentialsArgs.getAuthenticationHandler();
            } else {
                ConfigCredentials creds = this.getActiveProfile().getCredentials();
                if (creds instanceof CredentialsClientCredentialsImpl) {
                    authenticationHandler = new AnypointClientCredentialsAuthenticationHandler(((CredentialsClientCredentialsImpl)creds).getClientId(), ((CredentialsClientCredentialsImpl)creds).getClientSecret());
                } else if (creds instanceof CredentialsUsernamePasswordImpl) {
                    authenticationHandler = new AnypointUPWAuthenticationHandler(((CredentialsUsernamePasswordImpl)creds).getUsername(), ((CredentialsUsernamePasswordImpl)creds).getPassword());
                } else if (creds instanceof CredentialsBearerTokenImpl) {
                    authenticationHandler = new BearerTokenAuthenticationHandler(((CredentialsBearerTokenImpl)creds).getBearerToken());
                } else {
                    throw new IllegalStateException("No valid credentials specified in command or present in active configuration");
                }
            }
            this.anypointClient = AnypointClient.builder().baseUrl(this.anypointUrl.toString()).authenticationHandler(authenticationHandler).build();
        }
        return this.anypointClient;
    }

    public Environment getEnvironment(String organizationName, String environmentName) throws IOException, ProfileNotFoundException, NotFoundException {
        if (organizationName == null) {
            organizationName = this.getActiveProfile().getDefaultOrg();
        }
        if (environmentName == null) {
            environmentName = this.getActiveProfile().getDefaultEnv();
        }
        if (organizationName == null) {
            throw new IllegalArgumentException("Organization not set and no default is assigned in profile");
        }
        if (environmentName == null) {
            throw new IllegalArgumentException("Environment not set and no default is assigned in profile");
        }
        EnhancedMuleClient client = this.createEMClient();
        client.getLegacyAnypointClient().findEnvironment(organizationName, environmentName, false, false, null);
        return null;
    }

    public EnhancedMuleClient createEMClient() throws IOException, ProfileNotFoundException {
        ConfigCredentials credentials = this.credentialsArgs != null ? this.credentialsArgs.getCredentials() : null;
        ConfigProfile profile = this.getActiveProfile();
        if (credentials == null) {
            credentials = profile.getCredentials();
        }
        if (this.anypointUrl == null && profile.getAnypointUrl() != null) {
            this.anypointUrl = new URL(profile.getAnypointUrl());
        }
        return EnhancedMuleClient.builder(CredentialsConverter.convert(credentials)).proxySettings(null).anypointUrl(this.anypointUrl != null ? this.anypointUrl.toString() : null).insecure(profile.isInsecureServer()).build();
    }

    public Organization findOrganization(String organization) throws IOException, ProfileNotFoundException, NotFoundException {
        if (organization != null) {
            return this.createEMClient().getLegacyAnypointClient().findOrganizationByNameOrId(organization);
        }
        LegacyAnypointClient anypointClient = this.createEMClient().getLegacyAnypointClient();
        Organization org = anypointClient.getUser().getOrganization();
        org.setClient(anypointClient);
        return org;
    }
}

