/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.config;

import com.aeontronix.enhancedmule.tools.config.ConfigProfile;
import com.aeontronix.enhancedmule.tools.config.ProfileNotFoundException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EMConfig {
    public static final String DEFAULT = "default";
    @JsonProperty(value="profiles")
    private Map<String, ConfigProfile> profiles = new HashMap<String, ConfigProfile>();
    @JsonProperty(value="active")
    private String active = "default";

    public void save() throws IOException {
        File file = new File(System.getProperty("user.home") + File.separator + ".enhanced-mule.config.json");
        new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).writerWithDefaultPrettyPrinter().writeValue(file, (Object)this);
    }

    public static EMConfig findConfigFile() throws IOException {
        return EMConfig.findConfigFile(null);
    }

    public String getActive() {
        return this.active;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public void checkProfileExists(String profileName) throws ProfileNotFoundException {
        if (profileName == null) {
            return;
        }
        if (this.profiles == null ? profileName.equalsIgnoreCase(DEFAULT) : this.profiles.containsKey(profileName)) {
            return;
        }
        throw new ProfileNotFoundException(profileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EMConfig findConfigFile(String filename) throws IOException {
        if (filename == null) {
            filename = "enhanced-mule.config.json";
        }
        InputStream is = null;
        is = EMConfig.findConfig(filename);
        if (is != null) {
            EMConfig eMConfig = (EMConfig)new ObjectMapper().readValue(is, EMConfig.class);
            return eMConfig;
        }
        EMConfig cfg = new EMConfig();
        cfg.getOrCreateProfile(cfg.getActive());
        EMConfig eMConfig = cfg;
        return eMConfig;
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static InputStream findConfig(String filename) throws FileNotFoundException {
        File file = new File(filename);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        file = new File(System.getProperty("user.home") + File.separatorChar + "." + filename);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        file = new File(System.getProperty("user.home") + File.separatorChar + ".enhanced-mule" + File.separatorChar + filename);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        InputStream is = EMConfig.class.getClassLoader().getResourceAsStream(filename);
        if (is != null) {
            return is;
        }
        is = EMConfig.class.getClassLoader().getResourceAsStream("/" + filename);
        if (is != null) {
            return is;
        }
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        if (is != null) {
            return is;
        }
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/" + filename);
        return is;
    }

    @JsonIgnore
    public ConfigProfile getOrCreateProfile(String profile) {
        ConfigProfile configProfile = this.profiles.get(profile);
        if (configProfile == null) {
            configProfile = new ConfigProfile();
        }
        return configProfile;
    }

    @JsonIgnore
    public ConfigProfile getActiveProfile() {
        return this.getProfiles().computeIfAbsent(this.active, s -> new ConfigProfile());
    }

    @JsonIgnore
    public ConfigProfile getProfile(@Nullable String profile) throws ProfileNotFoundException {
        return profile != null ? this.getProfileByProfileName(profile) : this.getActiveProfile();
    }

    @JsonIgnore
    public ConfigProfile getProfileByProfileName(@NotNull String profile) throws ProfileNotFoundException {
        ConfigProfile p = this.profiles.get(profile);
        if (p != null) {
            return p;
        }
        if (DEFAULT.equalsIgnoreCase(profile)) {
            p = new ConfigProfile();
            this.profiles.put(DEFAULT, p);
            return p;
        }
        throw new ProfileNotFoundException(profile);
    }

    @JsonIgnore
    private ConfigProfile getDefaultProfile() {
        return this.profiles.computeIfAbsent(DEFAULT, s -> new ConfigProfile());
    }

    @NotNull
    public Map<String, ConfigProfile> getProfiles() {
        if (this.profiles == null) {
            this.profiles = new HashMap<String, ConfigProfile>();
            this.profiles.put(DEFAULT, new ConfigProfile());
        }
        return this.profiles;
    }

    public void setProfiles(@NotNull Map<String, ConfigProfile> profiles) {
        this.profiles = profiles;
    }

    private static boolean isNotBlank(String str) {
        return str != null && !str.trim().isEmpty();
    }
}

