/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.util;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.URLBuilder;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.commons.file.TempFile;
import com.aeontronix.commons.xml.XmlUtils;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.application.ApplicationArchiveVersionTransformer;
import com.aeontronix.enhancedmule.tools.anypoint.application.ApplicationIdentifier;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.unpack.FileType;
import com.aeontronix.unpack.UnpackException;
import com.aeontronix.unpack.Unpacker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipFile;
import org.fusesource.jansi.Ansi;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MavenHelper {
    private static final Logger logger = LoggerFactory.getLogger(MavenHelper.class);
    public static final String SETTINGS_NS = "http://maven.apache.org/SETTINGS/1.1.0";

    public static ApplicationIdentifier uploadToMaven(ApplicationIdentifier appId, Organization org, ApplicationSource applicationSource, String newVersion, String buildNumber) throws IOException, UnpackException {
        ApplicationIdentifier newAppId;
        if (buildNumber == null) {
            buildNumber = MavenHelper.generateTimestampString();
        }
        File appArchFile = applicationSource.getLocalFile();
        if (appId == null) {
            try (ZipFile zipFile = new ZipFile(appArchFile);){
                appId = MavenHelper.getApplicationIdentifier(org, zipFile);
            }
        }
        if (newVersion == null && appId.getVersion().toLowerCase().endsWith("-snapshot")) {
            newVersion = appId.getVersion() + "-" + buildNumber;
            newAppId = new ApplicationIdentifier(org.getId(), appId.getArtifactId(), newVersion);
            logger.info(Ansi.ansi().fgBrightYellow().a("Snapshot version: ").reset().a(newVersion).toString());
        } else {
            newAppId = new ApplicationIdentifier(org.getId(), appId.getArtifactId(), appId.getVersion());
        }
        if (!org.getId().equals(appId.getGroupId()) || newVersion != null) {
            try (TempFile emteh = new TempFile("emteh");){
                Unpacker unpacker = new Unpacker(appArchFile, FileType.ZIP, (File)emteh, FileType.ZIP);
                unpacker.addTransformers(ApplicationArchiveVersionTransformer.getTransformers(appId, org.getId(), newVersion, buildNumber));
                unpacker.unpack();
                MavenHelper.publishArchive(newAppId, org, (File)emteh);
            }
        } else {
            MavenHelper.publishArchive(newAppId, org, appArchFile);
        }
        return new ApplicationIdentifier(org.getId(), appId.getArtifactId(), newVersion != null ? newVersion : appId.getVersion());
    }

    public static void publishArchive(ApplicationIdentifier appId, Organization org, File appArchFile) throws IOException {
        try (ZipFile zipFile = new ZipFile(appArchFile);){
            MavenHelper.publishFile(org, appId, zipFile, MavenHelper.pomPath(appId, org.getId()), ".pom");
            logger.debug("Uploaded POM");
            MavenHelper.publishFile(org, appId, zipFile, "anypoint.json", "-anypoint-descriptor.json");
            logger.debug("Uploaded anypoint.json");
        }
        try (FileInputStream is = new FileInputStream(appArchFile);){
            org.getClient().getHttpHelper().httpPutBasicAuth(MavenHelper.createMavenUrl(org, appId).path(appId.getArtifactId() + "-" + appId.getVersion() + "-mule-application.jar").toString(), is, null);
            logger.debug("Uploaded Application");
        }
    }

    @NotNull
    public static String pomPath(ApplicationIdentifier appId, String orgId) {
        return MavenHelper.mavenMetaPath(appId, orgId, "pom.xml");
    }

    @NotNull
    public static String mavenMetaPath(ApplicationIdentifier appId, String orgId, String file) {
        return "META-INF/maven/" + orgId + "/" + appId.getArtifactId() + "/" + file;
    }

    private static ApplicationIdentifier getApplicationIdentifier(Organization org, ZipFile zipFile) throws IOException {
        Map classloaderModel = (Map)org.getClient().getJsonHelper().getJsonMapper().readValue(zipFile.getInputStream(zipFile.getEntry("META-INF/mule-artifact/classloader-model.json")), Map.class);
        Map artifactCoordinates = (Map)classloaderModel.get("artifactCoordinates");
        if (artifactCoordinates == null) {
            throw new UnexpectedException("Invalid classloader-model.json: artifactCoordinates missing");
        }
        String groupId = (String)artifactCoordinates.get("groupId");
        String artifactId = (String)artifactCoordinates.get("artifactId");
        String version = (String)artifactCoordinates.get("version");
        if (StringUtils.isBlank((String)groupId) || StringUtils.isBlank((String)artifactId) || StringUtils.isBlank((String)version)) {
            throw new UnexpectedException("Invalid classloader-model.json: groupId or artifactId missing");
        }
        return new ApplicationIdentifier(groupId, artifactId, version);
    }

    private static void publishFile(Organization org, ApplicationIdentifier appId, ZipFile zipFile, String path, String ext) throws IOException {
        try (InputStream pomData = zipFile.getInputStream(zipFile.getEntry(path));){
            org.getClient().getHttpHelper().httpPutBasicAuth(MavenHelper.createMavenUrl(org, appId).path(appId.getArtifactId() + "-" + appId.getVersion() + ext).toString(), pomData, null);
        }
    }

    private static URLBuilder createMavenUrl(Organization org, ApplicationIdentifier appId) {
        return new URLBuilder("https://maven.anypoint.mulesoft.com/api/v2/organizations/" + org.getId() + "/maven").path(org.getId(), true).path(appId.getArtifactId(), true).path(appId.getVersion(), true);
    }

    @NotNull
    public static String generateTimestampString() {
        return DateTimeFormatter.ofPattern("yyyyMMddHHmmssSS").format(LocalDateTime.now());
    }

    public static void updateMavenSettings(@NotNull File mavenSettingsFile, String activeProfileId, String bearerToken) throws SAXException, IOException {
        block13: {
            Element server;
            Element root;
            Document settingsDoc;
            File oldFile;
            String serverId = activeProfileId.equals("default") ? "anypoint-exchange" : "anypoint-exchange-" + activeProfileId;
            if (mavenSettingsFile.exists()) {
                oldFile = new File(mavenSettingsFile.getPath() + ".old");
                settingsDoc = XmlUtils.parse((File)mavenSettingsFile, (boolean)true);
                root = XmlUtils.getChildElement((Node)settingsDoc, (String)"settings", (boolean)true);
            } else {
                oldFile = null;
                settingsDoc = XmlUtils.createDocument((boolean)true);
                root = settingsDoc.createElementNS(SETTINGS_NS, "settings");
                settingsDoc.appendChild(root);
                root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xs:schemaLocation", "http://maven.apache.org/SETTINGS/1.1.0 http://maven.apache.org/xsd/settings-1.1.0.xsd");
            }
            Element servers = XmlUtils.getChildElement((Node)root, (String)"servers", (boolean)true);
            Optional<Element> serverOpt = XmlUtils.getChildNodes((Node)servers, Element.class).stream().filter(n -> {
                Element id = XmlUtils.getChildElement((Node)n, (String)"id", (boolean)false);
                return id != null && id.getTextContent().trim().equals(serverId);
            }).findFirst();
            if (!serverOpt.isPresent()) {
                server = XmlUtils.createElement((String)"server", (Node)servers, (Object[])new Object[0]);
                XmlUtils.createElement((String)"id", (Node)server, (Object[])new Object[0]).setTextContent(serverId);
            } else {
                server = serverOpt.get();
            }
            XmlUtils.getChildElement((Node)server, (String)"username", (boolean)true).setTextContent("~~~Token~~~");
            XmlUtils.getChildElement((Node)server, (String)"password", (boolean)true).setTextContent(bearerToken);
            if (oldFile != null) {
                mavenSettingsFile.renameTo(oldFile);
            }
            try (FileOutputStream stream = new FileOutputStream(mavenSettingsFile);){
                XmlUtils.serialize((Node)settingsDoc, (OutputStream)stream, (boolean)false, (boolean)true);
                if (oldFile != null) {
                    oldFile.delete();
                }
            }
            catch (Throwable e) {
                logger.error("An error occurred updating settings.xml, rolling back to old file");
                if (oldFile == null) break block13;
                oldFile.renameTo(mavenSettingsFile);
            }
        }
    }
}

