/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.provisioning;

import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetProvisioningException;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetVersion;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAsset;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAssetDescriptor;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ProvisioningRequest;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeManagementClient {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeManagementClient.class);
    private static final EMTLogger plogger = new EMTLogger(logger);
    public static final String SNAPSHOT_SUFFIX = "-snapshot";
    public static final int SNAPSHOT_SUFFIX_LEN = "-snapshot".length();

    public boolean publish(ExchangeAssetDescriptor asset, Organization organization, ApplicationSource source, ProvisioningRequest provisioningRequest) throws AssetProvisioningException {
        return asset.publish(organization, source, provisioningRequest);
    }

    public void deleteSnapshots(Organization organization, ExchangeAssetDescriptor asset) throws HttpException {
        String exclude;
        String version = asset.getVersion();
        int snapIdx = version.toLowerCase().indexOf(SNAPSHOT_SUFFIX);
        if (snapIdx != -1) {
            exclude = version;
            version = version.substring(0, snapIdx + SNAPSHOT_SUFFIX_LEN);
        } else {
            exclude = null;
            version = version + SNAPSHOT_SUFFIX;
        }
        try {
            ExchangeAsset exchangeAsset = organization.findExchangeAsset(organization.getId(), asset.getId());
            for (AssetVersion exchangeAssetVersion : exchangeAsset.getVersions()) {
                String v = exchangeAssetVersion.getVersion();
                if (!v.toLowerCase().startsWith(version.toLowerCase()) || exclude != null && exclude.equals(v)) continue;
                exchangeAssetVersion.delete();
                plogger.info(EMTLogger.Product.EXCHANGE, "Deleted snapshot exchange asset: {} : {}", asset.getId(), v);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

