/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.legacy.deploy.rtf;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.URLBuilder;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.application.ApplicationIdentifier;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.AbstractDeploymentRequest;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.DeploymentOperation;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.ExchangeDeploymentRequest;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.RuntimeDeploymentRequest;
import com.aeontronix.enhancedmule.tools.application.deployment.RTFDeploymentParameters;
import com.aeontronix.enhancedmule.tools.fabric.Fabric;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.legacy.deploy.FileApplicationSource;
import com.aeontronix.enhancedmule.tools.runtime.DeploymentResult;
import com.aeontronix.enhancedmule.tools.runtime.Target;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.MavenHelper;
import com.aeontronix.enhancedmule.tools.util.UnauthorizedHttpException;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.unpack.UnpackException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTFDeploymentOperation
extends DeploymentOperation {
    private static final Logger logger = LoggerFactory.getLogger(RTFDeploymentOperation.class);
    private static final EMTLogger emtLogger = new EMTLogger(logger);
    private AnypointClient anypointClient;
    private final Fabric fabric;

    public RTFDeploymentOperation(AnypointClient anypointClient, Fabric fabric, RuntimeDeploymentRequest req, Environment environment, ApplicationSource applicationSource) {
        super(req, environment, applicationSource);
        this.anypointClient = anypointClient;
        this.fabric = fabric;
    }

    @NotNull
    private static Map<String, Object> subMap(Map<String, Object> req, String name) {
        HashMap<String, Object> target = new HashMap<String, Object>();
        req.put(name, target);
        return target;
    }

    @Override
    protected DeploymentResult doDeploy(RuntimeDeploymentRequest request) throws IOException, HttpException {
        Object req;
        RTFDeploymentParameters rtf = request.getApplicationDescriptor().getDeploymentParams().getRtf();
        if (StringUtils.isBlank((String)rtf.getRuntimeVersion())) {
            try {
                Target target = this.environment.getOrganization().findTargetById(this.fabric.getId());
                Target.Runtime runtime = target.findRuntimeByType("mule");
                if (runtime == null) {
                    throw new IllegalArgumentException("Unable to find mule runtimes (no mule runtimes in fabric), please explicitly set runtime version");
                }
                List<Target.RuntimeVersion> versions = runtime.getVersions();
                if (versions == null || versions.isEmpty()) {
                    throw new IllegalArgumentException("Unable to find mule runtimes version (no versions found), please explicitly set runtime version");
                }
                Target.RuntimeVersion version = versions.get(0);
                rtf.setRuntimeVersion(version.getBaseVersion() + ":" + version.getTag());
            }
            catch (NotFoundException e) {
                throw new UnexpectedException("RTF Target not found: " + this.fabric.getId());
            }
        }
        ApplicationIdentifier appId = this.source.getApplicationIdentifier();
        if (this.source instanceof FileApplicationSource) {
            req = new ExchangeDeploymentRequest(request.getBuildNumber(), appId, this.getEnvironment().getOrganization(), this.source, null);
            try {
                appId = MavenHelper.uploadToMaven(this.anypointClient.getExchangeClient(), ((ExchangeDeploymentRequest)req).getAppId(), ((ExchangeDeploymentRequest)req).getOrg(), ((ExchangeDeploymentRequest)req).getApplicationSource(), null, ((AbstractDeploymentRequest)req).getBuildNumber());
            }
            catch (UnpackException e) {
                throw new UnauthorizedHttpException(e);
            }
            catch (RESTException e) {
                throw new IOException(e);
            }
            emtLogger.info(EMTLogger.Product.EXCHANGE, "Published application to exchange: " + appId.getGroupId() + ":" + appId.getArtifactId() + ":" + appId.getVersion(), new Object[0]);
        }
        req = new HashMap<String, Object>();
        req.put("name", request.getAppName());
        req.put("labels", Collections.singletonList("beta"));
        Map<String, Object> target = RTFDeploymentOperation.subMap((Map<String, Object>)req, "target");
        target.put("provider", "MC");
        target.put("targetId", this.fabric.getId());
        Map<String, Object> deploymentSettings = RTFDeploymentOperation.subMap(target, "deploymentSettings");
        Map<String, Object> resources = RTFDeploymentOperation.subMap(deploymentSettings, "resources");
        Map<String, Object> cpu = RTFDeploymentOperation.subMap(resources, "cpu");
        cpu.put("reserved", rtf.getCpuReserved());
        cpu.put("limit", rtf.getCpuLimit());
        Map<String, Object> memory = RTFDeploymentOperation.subMap(resources, "memory");
        memory.put("reserved", rtf.getMemoryReserved());
        memory.put("limit", rtf.getMemoryLimit());
        deploymentSettings.put("clustered", rtf.getClustered());
        deploymentSettings.put("enforceDeployingReplicasAcrossNodes", rtf.getEnforceDeployingReplicasAcrossNodes());
        Map<String, Object> http = RTFDeploymentOperation.subMap(deploymentSettings, "http");
        Map<String, Object> inbound = RTFDeploymentOperation.subMap(http, "inbound");
        inbound.put("publicUrl", rtf.getHttpInboundPublicUrl());
        Map<String, Object> jvm = RTFDeploymentOperation.subMap(deploymentSettings, "jvm");
        if (rtf.getJvmArgs() != null) {
            jvm.put("args", rtf.getJvmArgs());
        }
        deploymentSettings.put("runtimeVersion", rtf.getRuntimeVersion());
        deploymentSettings.put("lastMileSecurity", rtf.getLastMileSecurity());
        deploymentSettings.put("forwardSslSession", rtf.getForwardSslSession());
        deploymentSettings.put("updateStrategy", rtf.getUpdateStrategy() != null ? rtf.getUpdateStrategy().name().toLowerCase() : "rolling");
        Integer replicas = rtf.getReplicas();
        if (replicas == null) {
            replicas = 1;
        }
        target.put("replicas", replicas);
        Map<String, Object> application = RTFDeploymentOperation.subMap((Map<String, Object>)req, "application");
        Map<String, Object> ref = RTFDeploymentOperation.subMap(application, "ref");
        ref.put("groupId", appId.getGroupId());
        ref.put("artifactId", appId.getArtifactId());
        ref.put("version", appId.getVersion());
        ref.put("packaging", "jar");
        application.put("desiredState", "STARTED");
        Map<String, Object> configuration = RTFDeploymentOperation.subMap(application, "configuration");
        Map<String, Object> properties = RTFDeploymentOperation.subMap(configuration, "mule.agent.application.properties.service");
        properties.put("applicationName", request.getAppName());
        properties.put("properties", this.deploymentRequest.getProperties());
        properties.put("secureproperties", Collections.emptyMap());
        String deploymentId = this.getExistingAppDeploymentId(request.getAppName(), this.fabric.getId());
        if (StringUtils.isNotEmpty((String)deploymentId)) {
            String string = this.environment.getClient().getHttpHelper().httpPatch(new URLBuilder("/hybrid/api/v2/organizations").path(this.environment.getOrganization().getId()).path("environments").path(this.environment.getId()).path("deployments").path(deploymentId).toString(), req);
        } else {
            String string = this.environment.getClient().getHttpHelper().httpPost(new URLBuilder("/hybrid/api/v2/organizations").path(this.environment.getOrganization().getId()).path("environments").path(this.environment.getId()).path("deployments").toString(), req);
        }
        return null;
    }

    private String getExistingAppDeploymentId(String appName, String targetId) throws HttpException {
        logger.debug("Searching for pre-existing RTF application named " + appName);
        LegacyAnypointClient client = this.environment.getClient();
        String deployments = client.getHttpHelper().httpGet(new URLBuilder("/hybrid/api/v2/organizations").path(this.environment.getOrganization().getId()).path("environments").path(this.environment.getId()).path("deployments").toString());
        if (deployments != null) {
            for (JsonNode node : client.getJsonHelper().readJsonTree(deployments).at("/items")) {
                if (!appName.equalsIgnoreCase(node.get("name").asText()) || !targetId.equalsIgnoreCase(node.get("target").get("targetId").asText())) continue;
                return node.get("id").asText();
            }
        }
        return null;
    }
}

