/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.config;

import com.aeontronix.enhancedmule.tools.cli.EMTCli;
import com.aeontronix.enhancedmule.tools.cli.config.ConfigCmd;
import com.aeontronix.enhancedmule.tools.config.ConfigProfile;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="set", description={"Set configuration parameters"})
public class ConfigSetCmd
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigSetCmd.class);
    @CommandLine.ParentCommand
    private ConfigCmd parent;
    @CommandLine.Option(names={"-c", "--clear-unset"}, description={"If this is set, then any configuration not specified in the command will be reset to default value"})
    private boolean clearUnset;
    @CommandLine.Option(names={"-s", "--server-url"}, description={"Set server url"})
    private String serverUrl;
    @CommandLine.Option(names={"-i", "--insecure-server"}, description={"Allow insecure server with invalid SSL certificate"}, negatable=true)
    private Boolean insecureServer;
    @CommandLine.Option(names={"-u", "--anypoint-url"}, description={"Set anypoint url"})
    private String anypointUrl;
    @CommandLine.Option(names={"-d", "--domain"}, description={"Set anypoint org domain"})
    private String orgDomain;
    @CommandLine.Option(names={"-e", "--default-env"}, description={"Set default environment"})
    private String defaultEnv;
    @CommandLine.Option(names={"-o", "--default-org"}, description={"Set default org"})
    private String defaultOrg;

    @Override
    public Integer call() throws Exception {
        EMTCli cli = this.parent.getCli();
        ConfigProfile profile = cli.getActiveProfile();
        if (this.anypointUrl == null && this.serverUrl == null && this.defaultEnv == null && this.defaultOrg == null && this.insecureServer == null && this.orgDomain == null) {
            logger.warn("No configuration option selected");
        } else {
            if (this.anypointUrl != null) {
                if (this.anypointUrl.equals("gov")) {
                    this.anypointUrl = "https://gov.anypoint.mulesoft.com/";
                }
                profile.setAnypointUrl(this.anypointUrl);
                logger.info("Anypoint URL set to " + this.anypointUrl);
            } else if (this.clearUnset) {
                profile.setAnypointUrl(null);
                logger.info("Anypoint URL set to default value");
            }
            if (this.serverUrl != null) {
                profile.setServerUrl(this.serverUrl);
                logger.info("Enhanced Mule Server URL set to " + this.anypointUrl);
            } else if (this.clearUnset) {
                profile.setServerUrl(null);
                logger.info("Enhanced Mule Server URL removed");
            }
            if (this.defaultEnv != null) {
                profile.setDefaultEnv(this.defaultEnv);
                logger.info("Default environment set to " + this.defaultEnv);
            } else if (this.clearUnset) {
                profile.setDefaultEnv(null);
                logger.info("Default environment removed");
            }
            if (this.defaultOrg != null) {
                profile.setDefaultOrg(this.defaultOrg);
                logger.info("Default org set to " + this.defaultOrg);
            } else if (this.clearUnset) {
                profile.setDefaultOrg(null);
                logger.info("Default org removed");
            }
            if (this.orgDomain != null) {
                profile.setOrgDomain(this.orgDomain);
                logger.info("Org domain set to " + this.defaultOrg);
            } else if (this.clearUnset) {
                profile.setDefaultOrg(null);
                logger.info("Org domain removed");
            }
            if (this.insecureServer != null) {
                profile.setInsecureServer(this.insecureServer);
                if (this.insecureServer.booleanValue()) {
                    logger.info("Allowing insecure communication to enhanced mule server");
                } else {
                    logger.info("Disallowing insecure communication to enhanced mule server");
                }
            } else if (this.clearUnset) {
                profile.setInsecureServer(false);
                logger.info("Disallowing insecure communication to enhanced mule server");
            }
            cli.saveConfig();
        }
        return 0;
    }
}

