/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.emclient;

import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.authentication.AuthenticationProviderBearerTokenImpl;
import com.aeontronix.enhancedmule.tools.emclient.authentication.AnypointBearerTokenCredentialsProvider;
import com.aeontronix.enhancedmule.tools.emclient.authentication.CredentialsProvider;
import com.aeontronix.enhancedmule.tools.util.UnauthorizedHttpException;
import com.aeontronix.restclient.ProxySettings;
import com.aeontronix.restclient.RESTClient;
import com.aeontronix.restclient.RESTClientHost;
import com.aeontronix.restclient.RESTClientHostBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;

public class EnhancedMuleClient
implements Closeable,
AutoCloseable {
    public static final String EM_CLOUD_SERVER_URL = "https://api.enhanced-mule.com";
    public static final String DEFAULT_ANYPOINT_URL = "https://anypoint.mulesoft.com/";
    private final String anypointUrl;
    private CredentialsProvider credentialsProvider;
    private String exchangeMavenBaseUrl = "https://maven.anypoint.mulesoft.com";
    private String exchangeMavenPath = "/api/v2/maven";
    private RESTClientHost anypointRestClient;
    private String serverUrl;
    private ProxySettings proxySettings;
    private RESTClient restClient;
    private RESTClientHost serverRestClient;

    private EnhancedMuleClient(String serverUrl, ProxySettings proxySettings, String anypointUrl, CredentialsProvider credentialsProvider, boolean insecureServer) {
        this.serverUrl = serverUrl;
        this.proxySettings = proxySettings;
        this.credentialsProvider = credentialsProvider;
        this.restClient = RESTClient.builder().insecure(insecureServer).proxy(this.proxySettings).build();
        this.anypointUrl = anypointUrl == null ? DEFAULT_ANYPOINT_URL : anypointUrl;
        RESTClientHostBuilder anypointRestClientBuilder = this.restClient.host(this.anypointUrl);
        if (this.credentialsProvider != null) {
            anypointRestClientBuilder.authenticationHandler(this.credentialsProvider.toAuthenticationHandler(this.restClient, this.anypointUrl));
        }
        this.anypointRestClient = anypointRestClientBuilder.build();
        this.serverRestClient = this.restClient.host(this.serverUrl).build();
    }

    public RESTClient getRestClient() {
        return this.restClient;
    }

    public RESTClientHost getAnypointRestClient() {
        return this.anypointRestClient;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Object[])new Object[]{this.restClient});
    }

    public LegacyAnypointClient getLegacyAnypointClient() throws IOException {
        if (this.credentialsProvider instanceof AnypointBearerTokenCredentialsProvider) {
            String anypointBearerToken = ((AnypointBearerTokenCredentialsProvider)this.credentialsProvider).getAnypointBearerToken(this);
            LegacyAnypointClient anypointClient = new LegacyAnypointClient(new AuthenticationProviderBearerTokenImpl(anypointBearerToken), this.anypointUrl);
            if (this.proxySettings != null) {
                URI proxyUri = this.proxySettings.getProxyUri();
                anypointClient.setProxy(proxyUri.getScheme(), proxyUri.getHost(), proxyUri.getPort(), this.proxySettings.getProxyUsername(), this.proxySettings.getProxyPassword());
            }
            return anypointClient;
        }
        throw new RuntimeException("Credentials provider is not a AnypointBearerTokenCredentialsProvider");
    }

    public String getAnypointPlatformUrl() {
        return this.anypointUrl;
    }

    public String getExchangeMavenUrl() {
        return this.exchangeMavenBaseUrl + this.exchangeMavenPath;
    }

    public String getExchangeMavenBaseUrl() {
        return this.exchangeMavenBaseUrl;
    }

    public String getAnypointBearerToken() throws IOException {
        if (this.credentialsProvider instanceof AnypointBearerTokenCredentialsProvider) {
            return ((AnypointBearerTokenCredentialsProvider)this.credentialsProvider).getAnypointBearerToken(this);
        }
        throw new UnauthorizedHttpException("Not supported");
    }

    public static Builder builder(CredentialsProvider credentialsProvider) {
        return new Builder(credentialsProvider);
    }

    public static class Builder {
        private ProxySettings proxySettings;
        private String anypointUrl;
        private String serverUrl = "https://api.enhanced-mule.com";
        private CredentialsProvider credentialsProvider;
        private boolean insecure;

        private Builder(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
        }

        public Builder proxySettings(ProxySettings proxySettings) {
            this.proxySettings = proxySettings;
            return this;
        }

        public Builder anypointUrl(String anypointUrl) {
            this.anypointUrl = anypointUrl;
            return this;
        }

        public Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder insecure(boolean insecure) {
            this.insecure = insecure;
            return this;
        }

        public EnhancedMuleClient build() {
            return new EnhancedMuleClient(this.serverUrl, this.proxySettings, this.anypointUrl, this.credentialsProvider, this.insecure);
        }
    }
}

