/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.application.deploy;

import com.aeontronix.enhancedmule.propertiesprovider.utils.JacksonFlattener;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.AbstractDeploymentRequest;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ProvisioningRequest;
import com.aeontronix.enhancedmule.tools.application.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.application.deployment.DeploymentParameters;
import com.aeontronix.enhancedmule.tools.runtime.CHApplication;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeDeploymentRequest
extends AbstractDeploymentRequest
implements ProvisioningRequest {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeDeploymentRequest.class);
    private ApplicationDescriptor applicationDescriptor;
    private String appName;
    private String artifactId;
    private Environment environment;
    private boolean injectEnvInfo;
    private String target;
    private String filename;
    private final HashMap<String, String> vars = new HashMap();
    private final HashMap<String, String> properties = new HashMap();
    private HashSet<String> overrideProperties = new HashSet();
    private HashSet<String> secureProperties = new HashSet();
    private Map<String, String> fileProperties;
    private String filePropertiesPath = "config.properties";
    private boolean filePropertiesSecure;
    private boolean skipWait;
    private boolean skipProvisioning;
    private JsonNode legacyAppDescriptor;
    private boolean deleteSnapshots;

    public RuntimeDeploymentRequest(String filename, String appName, String artifactId, String buildNumber, Map<String, String> vars, Map<String, String> properties, File propertyfile, boolean ignoreMissingPropertyFile, String target, Environment environment, boolean injectEnvInfo, boolean skipWait, boolean skipProvisioning, JsonNode legacyAppDescriptor) throws IOException {
        super(buildNumber);
        this.filename = filename;
        this.appName = appName;
        this.artifactId = artifactId;
        this.environment = environment;
        this.injectEnvInfo = injectEnvInfo;
        this.skipWait = skipWait;
        this.skipProvisioning = skipProvisioning;
        this.legacyAppDescriptor = legacyAppDescriptor;
        if (vars != null && !vars.isEmpty()) {
            this.vars.putAll(vars);
        }
        this.properties.putAll(this.buildProperties(properties, propertyfile, ignoreMissingPropertyFile, injectEnvInfo));
        this.target = target;
        this.vars.put("environment.id", environment.getId());
        this.vars.put("environment.name", environment.getName());
        this.vars.put("environment.lname", environment.getLName());
        this.vars.put("environment.suffix", environment.getSuffix());
        this.vars.put("environment.type", environment.getType() != null ? environment.getType().name() : null);
        this.vars.put("organization.name", environment.getOrganization().getName());
        this.vars.put("organization.lname", environment.getOrganization().getName().replace(" ", "_").toLowerCase());
    }

    private Map<String, String> buildProperties(Map<String, String> properties, File propertyfile, boolean ignoreMissingPropertyFile, boolean injectEnvInfo) throws IOException {
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        if (propertyfile != null) {
            if (propertyfile.exists()) {
                String propFilePath = propertyfile.getPath().toLowerCase();
                if (propFilePath.endsWith(".properties")) {
                    Properties fileProps = new Properties();
                    try (FileInputStream fis = new FileInputStream(propertyfile);){
                        fileProps.load(fis);
                    }
                    for (Map.Entry<Object, Object> entry : fileProps.entrySet()) {
                        String key = entry.getKey().toString();
                        if (properties.containsKey(key)) continue;
                        properties.put(key, entry.getValue().toString());
                    }
                } else if (propFilePath.endsWith(".json") || propFilePath.endsWith(".yaml")) {
                    ObjectMapper objectMapper = propFilePath.endsWith(".json") ? new ObjectMapper() : new ObjectMapper((JsonFactory)new YAMLFactory());
                    properties.putAll(JacksonFlattener.flattenToStringMap((Map)objectMapper.readValue(new File(propFilePath), Map.class)));
                }
            } else if (!ignoreMissingPropertyFile) {
                throw new IllegalArgumentException("Property file not found: " + propertyfile);
            }
        }
        if (injectEnvInfo) {
            this.setProperty("anypoint.env.name", this.environment.getName());
            this.setProperty("anypoint.env.suffix", this.environment.getSuffix());
            this.setProperty("anypoint.env.id", this.environment.getId());
            this.setProperty("anypoint.env.type", this.environment.getType().name());
            this.setProperty("anypoint.org.name", this.environment.getOrganization().getName());
            this.setProperty("anypoint.org.id", this.environment.getOrganization().getId());
        }
        return properties;
    }

    public void mergeExistingProperties(CHApplication existingApp) {
        if (existingApp != null) {
            Map<String, String> props = existingApp.getProperties();
            DeploymentParameters dp = this.getApplicationDescriptor().getDeploymentParams();
            Boolean mergeExistingProperties = dp.getMergeExistingProperties();
            if ((mergeExistingProperties == null || mergeExistingProperties.booleanValue()) && props != null) {
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    String key = entry.getKey();
                    if (this.properties.containsKey(key) && !Boolean.TRUE.equals(dp.getMergeExistingPropertiesOverride()) || this.overrideProperties.contains(key)) continue;
                    this.properties.put(key, entry.getValue());
                }
            }
        }
    }

    public HashMap<String, String> getVars() {
        return this.vars;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public HashSet<String> getSecureProperties() {
        return this.secureProperties;
    }

    public void addProperties(Map<String, String> properties) {
        properties.putAll(properties);
    }

    public Map<String, String> getFileProperties() {
        return this.fileProperties;
    }

    public void setFileProperties(Map<String, String> fileProperties) {
        this.fileProperties = fileProperties;
    }

    public boolean isFilePropertiesSecure() {
        return this.filePropertiesSecure;
    }

    public void setFilePropertiesSecure(boolean filePropertiesSecure) {
        this.filePropertiesSecure = filePropertiesSecure;
    }

    public void setOverrideProperty(String key, String value) {
        this.properties.put(key, value);
        this.overrideProperties.add(key);
    }

    public void setSecureOverrideProperty(String key, String value) {
        this.setOverrideProperty(key, value);
        this.secureProperties.add(key);
    }

    public void addFileProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Property key musn't be null. value=" + value);
        }
        if (value == null) {
            throw new IllegalArgumentException("Property value musn't be null: " + key);
        }
        this.fileProperties.put(key, value);
    }

    public String getFilePropertiesPath() {
        return this.filePropertiesPath;
    }

    public void setFilePropertiesPath(String filePropertiesPath) {
        this.filePropertiesPath = filePropertiesPath;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void setSecureProperty(String key) {
        this.secureProperties.add(key);
    }

    public void setSecureProperty(String key, String value) {
        this.properties.put(key, value);
        this.setSecureProperty(key);
    }

    public void addSecureProperties(Collection<String> secureProperties) {
        this.secureProperties.addAll(secureProperties);
    }

    public boolean isSkipWait() {
        return this.skipWait;
    }

    public void setSkipWait(boolean skipWait) {
        this.skipWait = skipWait;
    }

    public boolean isSkipProvisioning() {
        return this.skipProvisioning;
    }

    public void setSkipProvisioning(boolean skipProvisioning) {
        this.skipProvisioning = skipProvisioning;
    }

    @Override
    public boolean isDeleteSnapshots() {
        return this.deleteSnapshots;
    }

    public void setDeleteSnapshots(boolean deleteSnapshots) {
        this.deleteSnapshots = deleteSnapshots;
    }

    @Override
    public ApplicationDescriptor getApplicationDescriptor() {
        return this.applicationDescriptor;
    }

    public void setApplicationDescriptor(ApplicationDescriptor applicationDescriptor) {
        this.applicationDescriptor = applicationDescriptor;
    }

    @Override
    public boolean isAutoApproveAPIAccessRequest() {
        Boolean autoApproveAccess = this.applicationDescriptor.getDeploymentParams().getAutoApproveAccess();
        return autoApproveAccess == null || autoApproveAccess != false;
    }

    public JsonNode getLegacyOverrides() {
        return this.legacyAppDescriptor;
    }
}

