/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.util;

import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMTProperties {
    private static final Logger logger = LoggerFactory.getLogger(EMTProperties.class);
    public static final String EMT_ENV = "emt.env";
    public static final String EMT_ENVTYPE = "emt.envtype";
    private final Map<String, String> properties = new HashMap<String, String>();

    public EMTProperties(Map<String, String> props) {
        this(props, null, null, null);
    }

    public EMTProperties(Map<String, String> props, String envId, String envName, Environment.Type envType) {
        HashMap<String, String> envNameOv = new HashMap<String, String>();
        HashMap<String, String> envIdOv = new HashMap<String, String>();
        HashMap<String, String> envTypeOv = new HashMap<String, String>();
        for (Map.Entry<String, String> e : props.entrySet()) {
            String key = e.getKey();
            String lkey = e.getKey().toLowerCase();
            String val = e.getValue();
            if (lkey.startsWith(EMT_ENV) || lkey.startsWith(EMT_ENVTYPE)) {
                EMTProperties.addIfMatch(key, val, EMT_ENVTYPE, envType != null ? envType.name() : null, envTypeOv);
                EMTProperties.addIfMatch(key, val, EMT_ENV, envName, envNameOv);
                EMTProperties.addIfMatch(key, val, EMT_ENV, envId, envIdOv);
                continue;
            }
            this.properties.put(key, val);
        }
        this.properties.putAll(envTypeOv);
        this.properties.putAll(envNameOv);
        this.properties.putAll(envIdOv);
    }

    private static void addIfMatch(String key, String val, String prefix, String txt, Map<String, String> props) {
        if (txt != null) {
            String fullPrefix = prefix + "." + txt.toLowerCase().replace(" ", "_") + ".";
            if (key.toLowerCase().startsWith(fullPrefix)) {
                props.put("emt." + key.substring(fullPrefix.length()), val);
            }
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Boolean getProperty(String key, @Nullable Boolean defValue, String ... legacyKeys) {
        String result = this.getProperty(key, defValue != null ? defValue.toString() : null, legacyKeys);
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public String getProperty(String key, @Nullable String defValue, String ... legacyKeys) {
        return EMTProperties.getProperty(this.properties, key, defValue, legacyKeys);
    }

    public static String getProperty(Map<String, String> properties, String key, @Nullable String defValue, String ... legacyKeys) {
        String value = properties.get(key);
        if (value != null) {
            return value;
        }
        if (legacyKeys != null) {
            for (String legacyKey : legacyKeys) {
                value = properties.get(legacyKey);
                if (value == null) continue;
                logger.warn("Property '" + legacyKey + "' is deprecated, please use: " + key);
                return value;
            }
        }
        return defValue;
    }

    public Map<String, String> getPrefixedProperties(String prefix, boolean stripPrefix) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (Map.Entry<String, String> e : this.properties.entrySet()) {
            String key = e.getKey();
            if (!key.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            results.put(stripPrefix ? key.substring(prefix.length()) : key, e.getValue());
        }
        return results;
    }
}

