/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.propertiesprovider.utils;

import com.aeontronix.commons.StringUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class JacksonFlattener {
    public static Map<String, String> flattenToStringMap(Map<String, ? extends Object> inputMap) {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        JacksonFlattener.doFlatten("", inputMap.entrySet().iterator(), resultMap, it -> it == null ? null : it.toString());
        return resultMap;
    }

    private static void doFlatten(String propertyPrefix, Iterator<? extends Map.Entry<String, ?>> inputMap, Map<String, ? extends Object> resultMap, Function<Object, Object> valueTransformer) {
        if (StringUtils.isNotBlank((String)propertyPrefix)) {
            propertyPrefix = propertyPrefix + ".";
        }
        while (inputMap.hasNext()) {
            Map.Entry<String, ?> entry = inputMap.next();
            JacksonFlattener.flattenElement(propertyPrefix.concat(entry.getKey()), entry.getValue(), resultMap, valueTransformer);
        }
    }

    private static void flattenElement(String propertyPrefix, Object source, Map<String, ?> resultMap, Function<Object, Object> valueTransformer) {
        if (source instanceof Iterable) {
            JacksonFlattener.flattenCollection(propertyPrefix, (Iterable)source, resultMap, valueTransformer);
            return;
        }
        if (source instanceof Map) {
            JacksonFlattener.doFlatten(propertyPrefix, ((Map)source).entrySet().iterator(), resultMap, valueTransformer);
            return;
        }
        resultMap.put(propertyPrefix, valueTransformer.apply(source));
    }

    private static void flattenCollection(String propertyPrefix, Iterable<Object> iterable, Map<String, ?> resultMap, Function<Object, Object> valueTransformer) {
        int counter = 0;
        for (Object element : iterable) {
            JacksonFlattener.flattenElement(propertyPrefix + "[" + counter + "]", element, resultMap, valueTransformer);
            ++counter;
        }
    }
}

