/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.commons.file.FileUtils;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.InvalidJsonException;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.Service;
import com.aeontronix.enhancedmule.tools.anypoint.User;
import com.aeontronix.enhancedmule.tools.anypoint.UserInfo;
import com.aeontronix.enhancedmule.tools.anypoint.alert.AlertUpdate;
import com.aeontronix.enhancedmule.tools.anypoint.authentication.AuthenticationProvider;
import com.aeontronix.enhancedmule.tools.anypoint.authentication.AuthenticationProviderUsernamePasswordImpl;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.HttpHelper;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.aeontronix.restclient.ProxySettings;
import com.aeontronix.restclient.RESTClient;
import com.aeontronix.restclient.RESTClientHost;
import com.aeontronix.restclient.RESTClientHostBuilder;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.auth.AuthenticationHandler;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyAnypointClient
implements Closeable,
Serializable {
    private static Pattern idRegex = Pattern.compile("[a-zA-Z0-9\\-]+");
    private static final Logger logger = LoggerFactory.getLogger(LegacyAnypointClient.class);
    protected JsonHelper jsonHelper;
    protected HttpHelper httpHelper;
    private int maxParallelDeployments = 5;
    private transient ExecutorService deploymentThreadPool;
    private ModelMapper modelMapper;
    private RESTClient restClient;
    private RESTClientHost anypointRestClient;
    private AnypointClient newClient;
    private ProxySettings proxySettings;
    private AuthenticationProvider authenticationProvider;
    private URI anypointBaseUrl;

    public LegacyAnypointClient() {
        if (!this.loadAnypointCliConfig()) {
            throw new IllegalStateException("Unable to find/load configurations");
        }
        this.init();
    }

    public LegacyAnypointClient(AuthenticationProvider authenticationProvider, String anypointBaseUrl) {
        this(authenticationProvider, 3, anypointBaseUrl);
    }

    public LegacyAnypointClient(AuthenticationProvider authenticationProvider, int maxParallelDeployments, String anypointBaseUrl) {
        this.maxParallelDeployments = maxParallelDeployments;
        this.jsonHelper = new JsonHelper(this);
        this.httpHelper = new HttpHelper(this.jsonHelper, authenticationProvider);
        this.jsonHelper.init(this.httpHelper);
        if (anypointBaseUrl == null) {
            anypointBaseUrl = "https://anypoint.mulesoft.com";
        }
        this.authenticationProvider = authenticationProvider;
        this.anypointBaseUrl = URI.create(anypointBaseUrl);
        this.init();
    }

    private void init() {
        this.deploymentThreadPool = Executors.newFixedThreadPool(this.maxParallelDeployments);
        this.modelMapper = new ModelMapper();
        this.modelMapper.validate();
        HashMap<Class, Object> jsonInjectables = new HashMap<Class, Object>();
        jsonInjectables.put(LegacyAnypointClient.class, this);
        jsonInjectables.put(HttpHelper.class, this.httpHelper);
        jsonInjectables.put(JsonHelper.class, this.jsonHelper);
        if (this.newClient != null) {
            jsonInjectables.put(AnypointClient.class, this.newClient);
        }
        RESTClient.Builder restClientBuilder = (RESTClient.Builder)RESTClient.builder().objectMapperInjections(jsonInjectables);
        if (this.proxySettings != null) {
            URI proxyUri = this.proxySettings.getProxyUri();
            this.httpHelper.setProxy(proxyUri.getScheme(), proxyUri.getHost(), proxyUri.getPort(), this.proxySettings.getProxyUsername(), this.proxySettings.getProxyPassword());
            restClientBuilder = restClientBuilder.proxy(this.proxySettings);
        }
        this.restClient = restClientBuilder.build();
        HttpHelper.setAnypointPlatformUrl(this.anypointBaseUrl.toString());
        this.anypointRestClient = ((RESTClientHostBuilder)this.restClient.host(this.anypointBaseUrl).authenticationHandler((AuthenticationHandler)this.authenticationProvider)).build();
    }

    private boolean loadAnypointCliConfig() {
        try {
            File cfg = new File(System.getProperty("user.home") + File.separator + ".anypoint" + File.separator + "credentials");
            if (cfg.exists()) {
                logger.debug("Loading anypoint cli config file " + cfg.getPath());
                JsonNode config = new ObjectMapper().readTree(cfg);
                JsonNode def = config.get("default");
                if (def != null && !def.isNull()) {
                    JsonNode usernameNode = def.get("username");
                    JsonNode passwordNode = def.get("password");
                    if (usernameNode != null && passwordNode != null && !usernameNode.isNull() && !passwordNode.isNull()) {
                        this.httpHelper = new HttpHelper(this.jsonHelper, new AuthenticationProviderUsernamePasswordImpl(usernameNode.asText(), passwordNode.asText()));
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unable to load anypoint cli configuration", (Throwable)e);
        }
        return false;
    }

    private <X> X loadService(Class<X> serviceClass) {
        X service;
        ServiceLoader<X> serviceLoader = ServiceLoader.load(serviceClass);
        Iterator<X> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            service = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalStateException("Found multiple implementations of ProvisioningService");
            }
        } else {
            try {
                service = serviceClass.isInterface() ? Class.forName(serviceClass.getName() + "Impl").asSubclass(serviceClass).newInstance() : serviceClass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new UnexpectedException((Throwable)e);
            }
        }
        if (service instanceof Service) {
            ((Service)service).setClient(this);
        }
        return service;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.deploymentThreadPool = Executors.newFixedThreadPool(this.maxParallelDeployments);
    }

    public int getMaxParallelDeployments() {
        return this.maxParallelDeployments;
    }

    public synchronized void setMaxParallelDeployments(int maxParallelDeployments) {
        if (maxParallelDeployments <= 0) {
            throw new IllegalArgumentException("maxParallelDeployments " + maxParallelDeployments + " is invalid (must be greater than 0)");
        }
        this.maxParallelDeployments = maxParallelDeployments;
        if (this.deploymentThreadPool != null) {
            this.deploymentThreadPool.shutdown();
        }
        this.deploymentThreadPool = Executors.newFixedThreadPool(maxParallelDeployments);
    }

    @Override
    public void close() throws IOException {
        this.httpHelper.close();
        if (this.deploymentThreadPool != null) {
            this.deploymentThreadPool.shutdown();
        }
    }

    public List<Organization> findOrganizations() throws HttpException {
        String json = this.httpHelper.httpGet("/accounts/api/me");
        ArrayList<Organization> list = new ArrayList<Organization>();
        for (JsonNode node : this.jsonHelper.readJsonTree(json).at("/user/memberOfOrganizations")) {
            list.add(this.jsonHelper.readJson(new Organization(this), node));
        }
        return list;
    }

    @NotNull
    public Organization findOrganizationByNameOrId(String nameOrId) throws NotFoundException, HttpException {
        for (Organization organization : this.findOrganizations()) {
            if (!organization.getId().equals(nameOrId) && !organization.getName().equals(nameOrId)) continue;
            return organization;
        }
        throw new NotFoundException("Organization not found: " + nameOrId + " (if using client credentials you must use org id instead of nameOrId)");
    }

    public Organization findOrganizationById(String id) throws HttpException, NotFoundException {
        Organization organization = new Organization(this);
        organization.setId(id);
        try {
            String json = this.httpHelper.httpGet(organization.getUriPath());
            this.jsonHelper.readJson(organization, json);
            return organization;
        }
        catch (HttpException e) {
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Enable to find organization " + id, e);
            }
            if (e.getStatusCode() == 403) {
                logger.debug("Access to organization data denied: " + id);
                return organization;
            }
            throw e;
        }
    }

    public User getUser() throws HttpException {
        try {
            return ((UserInfo)this.anypointRestClient.get("/accounts/api/me").execute().toObject(UserInfo.class)).getUser();
        }
        catch (RESTException e) {
            if (e.getStatusCode() > 0) {
                throw new HttpException(e.getStatusCode());
            }
            throw new HttpException(e);
        }
    }

    public Organization createOrganization(String name) throws HttpException {
        User user = this.getUser();
        return user.getOrganization().createSubOrganization(name, user.getId(), true, true);
    }

    public Organization createOrganization(String name, String ownerId, boolean createSubOrgs, boolean createEnvironments) throws HttpException {
        return this.getUser().getOrganization().createSubOrganization(name, ownerId, createSubOrgs, createEnvironments);
    }

    public Organization createOrganization(String name, String ownerId, boolean createSubOrgs, boolean createEnvironments, boolean globalDeployment, int vCoresProduction, int vCoresSandbox, int vCoresDesign, int staticIps, int vpcs, int loadBalancer) throws HttpException {
        return this.getUser().getOrganization().createSubOrganization(name, ownerId, createSubOrgs, createEnvironments, globalDeployment, vCoresProduction, vCoresSandbox, vCoresDesign, staticIps, vpcs, loadBalancer);
    }

    public JsonHelper getJsonHelper() {
        return this.jsonHelper;
    }

    public HttpHelper getHttpHelper() {
        return this.httpHelper;
    }

    public void setHttpHelper(HttpHelper httpHelper) {
        this.httpHelper = httpHelper;
    }

    public Environment findEnvironment(String organizationName, String environmentName, boolean createOrganization, boolean createEnvironment, Environment.Type createEnvironmentType) throws NotFoundException, HttpException {
        Organization organization;
        try {
            organization = this.findOrganizationByNameOrId(organizationName);
        }
        catch (NotFoundException e) {
            if (createOrganization) {
                organization = this.createOrganization(organizationName);
            }
            throw e;
        }
        try {
            return organization.findEnvironmentByName(environmentName);
        }
        catch (NotFoundException e) {
            if (createEnvironment) {
                return organization.createEnvironment(environmentName, createEnvironmentType);
            }
            throw e;
        }
    }

    public Set<Environment> findEnvironmentsRegexSearch(JsonNode targetJsonNode) throws HttpException {
        List<Organization> orgs = this.findOrganizations();
        if (targetJsonNode instanceof ArrayNode) {
            HashSet<Environment> combined = new HashSet<Environment>();
            for (JsonNode jsonNode : targetJsonNode) {
                combined.addAll(this.findEnvironmentsRegexSearch(jsonNode, orgs));
            }
            return combined;
        }
        return this.findEnvironmentsRegexSearch(targetJsonNode, orgs);
    }

    private Set<Environment> findEnvironmentsRegexSearch(String orgRegex, String envRegex) throws HttpException {
        return this.findEnvironmentsRegexSearch(orgRegex, envRegex, this.findOrganizations());
    }

    private Set<Environment> findEnvironmentsRegexSearch(JsonNode targetJsonNode, List<Organization> orgs) throws HttpException {
        JsonNode orgNode = targetJsonNode.get("org");
        if (orgNode == null) {
            throw new InvalidJsonException("Invalid target json, missing 'org' field");
        }
        JsonNode envNode = targetJsonNode.get("env");
        if (envNode == null) {
            throw new InvalidJsonException("Invalid target json, missing 'env' field");
        }
        return this.findEnvironmentsRegexSearch(orgNode.asText(), envNode.asText(), orgs);
    }

    private Set<Environment> findEnvironmentsRegexSearch(String orgRegex, String envRegex, List<Organization> orgs) throws HttpException {
        HashSet<Environment> envs = new HashSet<Environment>();
        Pattern orgPattern = Pattern.compile(orgRegex);
        Pattern envPattern = Pattern.compile(envRegex);
        for (Organization org : orgs) {
            if (!orgPattern.matcher(org.getName()).find()) continue;
            for (Environment environment : org.findAllEnvironments()) {
                if (!envPattern.matcher(environment.getName()).find()) continue;
                envs.add(environment);
            }
        }
        return envs;
    }

    public void applyAlerts(File alertsDescriptor) throws IOException, HttpException {
        if (!alertsDescriptor.exists()) {
            throw new IllegalArgumentException("Alerts data file not found: " + alertsDescriptor.getPath());
        }
        this.applyAlerts(FileUtils.toString((File)alertsDescriptor));
    }

    public void applyAlert(String name, JsonNode jsonNode) throws HttpException {
        JsonNode target = jsonNode.get("target");
        if (target == null) {
            throw new InvalidJsonException("Invalid alert json missing target: " + name);
        }
        Set<Environment> envs = this.findEnvironmentsRegexSearch(target);
        AlertUpdate alert = this.jsonHelper.readJson(AlertUpdate.class, jsonNode, this);
        alert.setName(name);
        this.applyAlert(envs, alert);
    }

    public void applyAlert(Set<Environment> environments, AlertUpdate alert) throws HttpException {
        for (Environment environment : environments) {
            environment.applyAlert(alert);
        }
    }

    private void applyAlerts(String json) throws HttpException {
        JsonNode jsonNode = this.jsonHelper.readJsonTree(json);
        if (!jsonNode.isObject()) {
            throw new InvalidJsonException("Invalid alert data file, root element should be an object");
        }
        JsonNode alertsNode = jsonNode.get("alerts");
        if (alertsNode != null) {
            Iterator it = alertsNode.fields();
            while (it.hasNext()) {
                Map.Entry field = (Map.Entry)it.next();
                String alertName = (String)field.getKey();
                if (StringUtils.isBlank((String)alertName)) {
                    throw new InvalidJsonException("Invalid alert, name must not be blank");
                }
                JsonNode alertNode = (JsonNode)field.getValue();
                this.applyAlert(alertName, alertNode);
            }
        }
    }

    public String getUserId() throws HttpException {
        return this.getUser().getId();
    }

    public void setProxy(String scheme, String host, int port, String username, String password) {
        try {
            this.proxySettings = new ProxySettings(new URI(scheme, null, host, port, null, null, null), username, password, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.init();
    }

    public void unsetProxy() {
        this.proxySettings = null;
        this.init();
    }

    public RESTClient getRestClient() {
        return this.restClient;
    }

    public RESTClientHost getAnypointRestClient() {
        return this.anypointRestClient;
    }

    public AnypointClient getNewClient() {
        return this.newClient;
    }

    public void setNewClient(AnypointClient newClient) {
        this.newClient = newClient;
        this.init();
    }

    public <X, Y extends AnypointObject> X map(Object object, Class<X> mappedClass, Y parent) {
        Object result = this.modelMapper.map(object, mappedClass);
        if (result instanceof AnypointObject) {
            ((AnypointObject)result).setClient(this);
            if (parent != null) {
                ((AnypointObject)result).setParent(parent);
            }
        }
        return (X)result;
    }
}

