/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.api;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.exchange.ExchangeClientApplication;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.api.API;
import com.aeontronix.enhancedmule.tools.anypoint.api.APIContract;
import com.aeontronix.enhancedmule.tools.anypoint.api.SLATier;
import com.aeontronix.enhancedmule.tools.anypoint.api.SLATierList;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetInstance;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.json.JsonConvertionException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientApplication
extends AnypointObject<Organization> {
    private static final Logger logger = LoggerFactory.getLogger(ClientApplication.class);
    private Integer id;
    private String name;
    private String description;
    private String url;
    private String clientId;
    private String clientSecret;

    public ClientApplication(LegacyAnypointClient client) {
        super(client);
    }

    public ClientApplication(Organization parent) {
        super(parent);
    }

    public ClientApplication() {
    }

    @JsonProperty
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @JsonProperty
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @JsonIgnore
    public String getUriPath() {
        return ((Organization)this.parent).getUriPath() + "/applications/" + this.id;
    }

    public static ClientApplication create(AnypointClient anypointClient, @NotNull Organization organization, @NotNull String name, String url, String description, List<String> redirectUri, String apiEndpoints, String accessedAPIInstanceId) throws HttpException {
        try {
            ExchangeClientApplication clientApplication = anypointClient.getExchangeClient().createClientApplication(organization.getId(), name, url, description, redirectUri, null, apiEndpoints, accessedAPIInstanceId);
            ClientApplication cApp = new ClientApplication();
            cApp.setName(clientApplication.getName());
            cApp.setClientId(clientApplication.getClientId());
            cApp.setClientSecret(clientApplication.getClientSecret());
            cApp.setId(clientApplication.getId());
            cApp.setDescription(clientApplication.getDescription());
            cApp.setUrl(url);
            return cApp;
        }
        catch (RESTException | JsonConvertionException e) {
            throw new HttpException(e);
        }
    }

    public static List<ClientApplication> find(AnypointClient client, LegacyAnypointClient legacyAnypointClient, Organization organization, String filter) throws HttpException {
        ArrayList<ClientApplication> list = new ArrayList<ClientApplication>();
        try {
            List clientApplications = client.getExchangeClient().listClientApplications(organization.getId());
            for (ExchangeClientApplication clientApplication : clientApplications) {
                if (!clientApplication.getName().contains(filter)) continue;
                list.add(legacyAnypointClient.map(clientApplication, ClientApplication.class, organization));
            }
        }
        catch (RESTException e) {
            throw new HttpException(e);
        }
        return list;
    }

    public void delete() throws HttpException {
        this.httpHelper.httpDelete(this.getUriPath());
    }

    public APIContract requestAPIAccess(API apiVersion) throws HttpException {
        return this.requestAPIAccess(apiVersion, null, false);
    }

    public APIContract requestAPIAccess(API apiVersion, SLATier tier) throws HttpException {
        return this.requestAPIAccess(apiVersion, tier, true);
    }

    public APIContract requestAPIAccess(API apiVersion, SLATier tier, boolean acceptedTerms) throws HttpException {
        SLATierList apiTiers;
        Long tierId;
        if (this.jsonHelper == null) {
            this.client = apiVersion.getClient();
            this.jsonHelper = this.client.getJsonHelper();
            this.httpHelper = this.client.getHttpHelper();
        }
        JsonHelper.MapBuilder mapBuilder = this.jsonHelper.buildJsonMap().set("apiId", apiVersion.getId()).set("environmentId", ((Environment)apiVersion.getParent()).getId()).set("acceptedTerms", acceptedTerms).set("organizationId", ((Organization)((Environment)apiVersion.getParent()).getParent()).getId()).set("groupId", apiVersion.getGroupId()).set("assetId", apiVersion.getAssetId()).set("version", apiVersion.getAssetVersion()).set("productAPIVersion", apiVersion.getProductVersion());
        if (tier != null && tier.getId() == null) {
            throw new IllegalArgumentException("Tier is missing tier id");
        }
        Long l = tierId = tier != null ? tier.getId() : null;
        if (tierId == null && (apiTiers = apiVersion.findSLATiers()).size() == 1) {
            tierId = ((SLATier)apiTiers.iterator().next()).getId();
        }
        if (tierId != null) {
            mapBuilder.set("requestedTierId", tierId);
        }
        Map<String, Object> req = mapBuilder.toMap();
        String json = this.httpHelper.httpPost("/exchange/api/v1/organizations/" + ((Organization)this.parent).getId() + "/applications/" + this.id + "/contracts", req);
        return this.jsonHelper.readJson(new APIContract(apiVersion), json);
    }

    public APIContract requestAPIAccess(API api, AssetInstance assetInstance) throws HttpException {
        return this.requestAPIAccess(api, assetInstance, null, false);
    }

    public APIContract requestAPIAccess(API api, AssetInstance assetInstance, SLATier tier) throws HttpException {
        return this.requestAPIAccess(api, assetInstance, tier, true);
    }

    public APIContract requestAPIAccess(API api, AssetInstance apiVersion, SLATier tier, boolean acceptedTerms) throws HttpException {
        Long tierId;
        JsonHelper.MapBuilder mapBuilder = this.jsonHelper.buildJsonMap().set("apiId", apiVersion.getId()).set("environmentId", apiVersion.getEnvironmentId()).set("acceptedTerms", acceptedTerms).set("organizationId", apiVersion.getOrganizationId()).set("groupId", apiVersion.getGroupId()).set("assetId", apiVersion.getAssetId()).set("version", apiVersion.getVersion()).set("productAPIVersion", apiVersion.getProductAPIVersion());
        if (tier != null && tier.getId() == null) {
            throw new IllegalArgumentException("Tier is missing tier id");
        }
        Long l = tierId = tier != null ? tier.getId() : null;
        if (tierId != null) {
            mapBuilder.set("requestedTierId", tierId);
        }
        Map<String, Object> req = mapBuilder.toMap();
        String json = this.httpHelper.httpPost("/exchange/api/v1/organizations/" + ((Organization)this.parent).getId() + "/applications/" + this.id + "/contracts", req);
        return this.jsonHelper.readJson(new APIContract(api), json);
    }
}

