/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.application;

import com.aeontronix.commons.Required;
import com.aeontronix.commons.file.FileUtils;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.application.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.APIDescriptor;
import com.aeontronix.unpack.FileType;
import com.aeontronix.unpack.SourceFile;
import com.aeontronix.unpack.UnpackException;
import com.aeontronix.unpack.Unpacker;
import com.aeontronix.unpack.transformer.FileMatcher;
import com.aeontronix.unpack.transformer.JacksonTransformer;
import com.aeontronix.unpack.transformer.Matcher;
import com.aeontronix.unpack.transformer.Transformer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationEnhancer {
    public static final String META_INF_MULE_ARTIFACT_MULE_ARTIFACT_JSON = "META-INF/mule-artifact/mule-artifact.json";
    public static final String ENHANCED_MULE_TOOLS_FLOW_XML = "enhanced-mule-tools-flow.xml";
    public static final String ANYPOINT_JSON = "anypoint.json";
    private static final Logger logger = LoggerFactory.getLogger(ApplicationEnhancer.class);

    public static void enhanceApplicationArchive(File file, final File descriptorFile, ApplicationDescriptor applicationDescriptor, boolean deletePreWeave, final boolean excludeIgnoreBasePath) throws IOException, UnpackException {
        if (logger.isDebugEnabled()) {
            logger.debug(System.getProperties().toString());
        }
        final boolean mulestudio = ApplicationEnhancer.checkProperty("eclipse.product", "mulestudio") || ApplicationEnhancer.checkProperty("eclipse.commands", "studio");
        File oldArtifactFile = new File(file.getPath() + ".preweaving");
        if (oldArtifactFile.exists()) {
            FileUtils.delete((File[])new File[]{oldArtifactFile});
        }
        if (!file.renameTo(oldArtifactFile)) {
            throw new IOException("Unable to move " + file.getPath() + " to " + oldArtifactFile.getPath());
        }
        Unpacker unpacker = new Unpacker(oldArtifactFile, FileType.ZIP, file, FileType.ZIP);
        ArrayList<Object> transformers = new ArrayList<Object>();
        transformers.add(new Transformer((Matcher)new FileMatcher(ANYPOINT_JSON, Required.CREATE)){

            public byte[] transform(SourceFile sourceFile) throws Exception {
                return FileUtils.toByteArray((File)descriptorFile);
            }
        });
        final APIDescriptor api = applicationDescriptor.getApi();
        final boolean autoDiscovery = api != null && api.isAddAutoDiscovery();
        transformers.add(new Transformer((Matcher)new FileMatcher(ENHANCED_MULE_TOOLS_FLOW_XML, Required.CREATE)){

            public byte[] transform(SourceFile sourceFile) throws Exception {
                StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mule xmlns:api-gateway=\"http://www.mulesoft.org/schema/mule/api-gateway\" xmlns=\"http://www.mulesoft.org/schema/mule/core\" xmlns:doc=\"http://www.mulesoft.org/schema/mule/documentation\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd http://www.mulesoft.org/schema/mule/api-gateway http://www.mulesoft.org/schema/mule/api-gateway/current/mule-api-gateway.xsd\">\n");
                if (autoDiscovery) {
                    if (mulestudio) {
                        logger.warn("Skipped adding autodiscovery since running on studio");
                    } else {
                        logger.info("Added autodiscovery using flow: " + api.getAutoDiscoveryFlow());
                        xml.append("    <api-gateway:autodiscovery apiId=\"${anypoint.api.id}\" ");
                        if (!excludeIgnoreBasePath) {
                            xml.append("ignoreBasePath=\"true\" ");
                        }
                        xml.append("flowRef=\"").append(api.getAutoDiscoveryFlow()).append("\" />\n");
                    }
                }
                xml.append("</mule>");
                return xml.toString().getBytes();
            }
        });
        transformers.add(new JacksonTransformer<ObjectNode>((Matcher)new FileMatcher(META_INF_MULE_ARTIFACT_MULE_ARTIFACT_JSON, Required.REQUIRED), ObjectNode.class, new ObjectMapper()){

            public JsonNode transform(ObjectNode root) throws Exception {
                ArrayNode configs;
                ObjectNode clm = this.getObject(root, "classLoaderModelLoaderDescriptor", true);
                ObjectNode clmAttr = this.getObject(clm, "attributes", true);
                ArrayNode exportedResources = this.getOrCreateArray(clmAttr, "exportedResources");
                if (!this.contains(exportedResources, ApplicationEnhancer.ENHANCED_MULE_TOOLS_FLOW_XML)) {
                    exportedResources.add(ApplicationEnhancer.ENHANCED_MULE_TOOLS_FLOW_XML);
                }
                if (!this.contains(configs = this.getOrCreateArray(root, "configs"), ApplicationEnhancer.ENHANCED_MULE_TOOLS_FLOW_XML)) {
                    configs.add(ApplicationEnhancer.ENHANCED_MULE_TOOLS_FLOW_XML);
                }
                ArrayNode secureProperties = this.getOrCreateArray(root, "secureProperties");
                this.addSecureProperty(secureProperties, "anypoint.platform.client_secret");
                this.addSecureProperty(secureProperties, "anypoint.api.client.secret");
                return root;
            }

            private void addSecureProperty(ArrayNode secureProperties, String propertyKey) {
                if (!this.contains(secureProperties, propertyKey)) {
                    secureProperties.add(propertyKey);
                }
            }
        });
        unpacker.addTransformers(transformers);
        unpacker.unpack();
        if (deletePreWeave) {
            oldArtifactFile.delete();
        }
    }

    private static boolean checkProperty(String key, String value) {
        String eclipse = System.getProperty(key);
        return eclipse != null && eclipse.toLowerCase().contains(value);
    }

    public byte[] getFile(File archive, String path) throws IOException {
        ZipFile zipFile = new ZipFile(archive);
        ZipEntry entry = zipFile.getEntry(path);
        if (entry != null) {
            return IOUtils.toByteArray((InputStream)zipFile.getInputStream(entry));
        }
        return null;
    }
}

