/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.application.deploy;

import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.enhancedmule.tools.util.EMTProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import java.io.IOException;
import java.util.Map;

public class DescriptorLayers {
    private ObjectNode defaults;
    private ObjectNode overrides;

    public DescriptorLayers(EMTProperties properties) {
        ObjectMapper objectMapper = new ObjectMapper();
        JavaPropsMapper propsMapper = new JavaPropsMapper();
        this.defaults = DescriptorLayers.getLayer("emt.defaults.", properties, objectMapper, propsMapper);
        this.overrides = DescriptorLayers.getLayer("emt.overrides.", properties, objectMapper, propsMapper);
    }

    public ObjectNode getDefaults() {
        return this.defaults;
    }

    public ObjectNode getOverrides() {
        return this.overrides;
    }

    public static ObjectNode getLayer(String prefix, EMTProperties properties, ObjectMapper objectMapper, JavaPropsMapper propsMapper) {
        try {
            Map<String, String> props = properties.getPrefixedProperties(prefix, true);
            return (ObjectNode)objectMapper.valueToTree(propsMapper.readMapAs(props, Map.class));
        }
        catch (IOException | IllegalArgumentException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }
}

