/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.exchange;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.file.FileUtils;
import com.aeontronix.commons.file.TempFile;
import com.aeontronix.enhancedmule.tools.anypoint.APISpecSource;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.api.API;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetCategory;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetProvisioningException;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAsset;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ProvisioningRequest;
import com.aeontronix.enhancedmule.tools.application.api.APICustomFieldDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.IconDescriptor;
import com.aeontronix.enhancedmule.tools.application.portal.PortalDescriptor;
import com.aeontronix.enhancedmule.tools.application.portal.PortalPageDescriptor;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeAssetDescriptor {
    public static final Pattern MAJOR_VERSION_PATTERN = Pattern.compile("^(\\d*)");
    private static final Logger logger = LoggerFactory.getLogger(ExchangeAssetDescriptor.class);
    private static final EMTLogger plogger = new EMTLogger(logger);
    private String groupId;
    @NotBlank
    private String id;
    @NotBlank
    private String version;
    @NotBlank
    private String apiVersion;
    private String name;
    private String description;
    private List<String> tags;
    private PortalDescriptor portal;
    private Map<String, List<String>> categories;
    private List<APICustomFieldDescriptor> fields;
    private IconDescriptor icon;
    private Boolean create = null;
    private Boolean provision = null;
    @NotNull
    private API.Type type = API.Type.REST;
    @NotBlank
    private String assetMainFile;

    public static String getMajorVersion(String version) {
        Matcher m = MAJOR_VERSION_PATTERN.matcher(version);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static File findIcon(File basedir) {
        for (String fn : Arrays.asList("icon.svg", "icon.png", "icon.jpeg", "icon.jpg", "icon.gif")) {
            File f = new File(basedir, fn);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public IconDescriptor getIcon() {
        return this.icon;
    }

    public void setIcon(IconDescriptor icon) {
        this.icon = icon;
    }

    public API.Type getType() {
        return this.type;
    }

    public void setType(API.Type type) {
        this.type = type;
    }

    public PortalDescriptor getPortal() {
        return this.portal;
    }

    public void setPortal(PortalDescriptor portal) {
        this.portal = portal;
    }

    public String getAssetMainFile() {
        return this.assetMainFile;
    }

    public void setAssetMainFile(String assetMainFile) {
        this.assetMainFile = assetMainFile;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public Map<String, List<String>> getCategories() {
        return this.categories;
    }

    public void setCategories(Map<String, List<String>> categories) {
        this.categories = categories;
    }

    public List<APICustomFieldDescriptor> getFields() {
        return this.fields;
    }

    public void setFields(List<APICustomFieldDescriptor> fields) {
        this.fields = fields;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getCreate() {
        return this.create;
    }

    public void setCreate(Boolean create) {
        this.create = create;
    }

    public Boolean getProvision() {
        return this.provision;
    }

    public void setProvision(Boolean provision) {
        this.provision = provision;
    }

    public void updateTags(ExchangeAsset exchangeAsset) throws HttpException {
        List<String> expectedTags;
        List<String> current;
        if (this.tags != null && !(current = exchangeAsset.getLabels()).equals(expectedTags = this.tags)) {
            exchangeAsset = exchangeAsset.updateLabels(expectedTags);
            plogger.info(EMTLogger.Product.EXCHANGE, "Updated tags of {} : {}", exchangeAsset.getAssetId(), expectedTags);
        }
    }

    public boolean publish(Organization organization, APISpecSource apiSpecSource, @NotNull ProvisioningRequest request) throws AssetProvisioningException {
        try {
            if (this.version.toLowerCase().endsWith("-snapshot")) {
                String oldVersion = this.version;
                this.version = oldVersion + "-" + request.getBuildNumber();
                plogger.info(EMTLogger.Product.EXCHANGE, "Snapshot version: {} => {}", oldVersion, this.version);
            }
            if (this.groupId == null) {
                this.groupId = organization.getId();
            }
            try {
                organization.findExchangeAssetVersion(this.groupId, this.id, this.version);
            }
            catch (NotFoundException e) {
                plogger.info(EMTLogger.Product.EXCHANGE, "Exchange asset {} : {} not found, publishing", this.id, this.version);
                if (this.type == API.Type.HTTP) {
                    organization.createExchangeHTTPAPIAsset(null, this.name, this.id, this.version, this.apiVersion);
                    plogger.info(EMTLogger.Product.EXCHANGE, "Created HTTP asset : {} : {} : {}", this.id, this.version, this.apiVersion);
                } else {
                    if (StringUtils.isBlank((String)this.assetMainFile)) {
                        throw new AssetProvisioningException("assetMainFile is required for API asset creation");
                    }
                    String assetClassifier = this.getClassifier();
                    try (TempFile apiSpecFile = new TempFile(this.id + "-" + this.version, ".zip");){
                        Set<String> files = apiSpecSource.listAPISpecFiles();
                        if (!files.contains(this.assetMainFile)) {
                            throw new IOException("asset main file not found: " + this.assetMainFile);
                        }
                        try (ZipOutputStream os = new ZipOutputStream(new FileOutputStream((File)apiSpecFile));){
                            for (String file : files) {
                                os.putNextEntry(new ZipEntry(file));
                                apiSpecSource.writeAPISpecFile(file, os);
                                os.closeEntry();
                            }
                        }
                        organization.publishExchangeAPIAsset(this.name, this.id, this.version, this.apiVersion, assetClassifier, this.assetMainFile, (File)apiSpecFile);
                        plogger.info(EMTLogger.Product.EXCHANGE, "Created API asset : {} : {} : {}", this.id, this.version, this.apiVersion);
                    }
                }
                return true;
            }
        }
        catch (IOException e) {
            throw new AssetProvisioningException(e);
        }
        return false;
    }

    public String getClassifier() {
        return this.assetMainFile != null ? (this.assetMainFile.toLowerCase().endsWith(".raml") ? "raml" : "oas") : null;
    }

    public void provision(Organization organization) throws IOException, NotFoundException {
        ExchangeAsset exchangeAsset = organization.findExchangeAsset(this.groupId != null ? this.groupId : organization.getId(), this.id);
        logger.debug("Provisioning API asset. create = " + this.create);
        if (this.create == Boolean.TRUE || this.provision != Boolean.FALSE || this.provision == Boolean.TRUE) {
            if (this.name != null && !this.name.equals(exchangeAsset.getName())) {
                exchangeAsset.updateName(this.name);
                plogger.info(EMTLogger.Product.EXCHANGE, "Updated exchange asset '{}' name", exchangeAsset.getAssetId());
            }
            if (this.description != null && !this.description.equals(exchangeAsset.getDescription())) {
                exchangeAsset.updateDescription(this.description);
                plogger.info(EMTLogger.Product.EXCHANGE, "Updated exchange asset '{}' description", exchangeAsset.getAssetId());
            }
            this.updateTags(exchangeAsset);
            if (this.icon != null) {
                exchangeAsset.updateIcon(StringUtils.base64Decode((String)this.icon.getContent()), this.icon.getMimeType());
                plogger.info(EMTLogger.Product.EXCHANGE, "Updated exchange asset '{}' icon", exchangeAsset.getAssetId());
            }
            ExchangeAsset.CustomFieldUpdateResults results = exchangeAsset.updateCustomFields(this.fields);
            for (String field : results.getModified()) {
                plogger.info(EMTLogger.Product.EXCHANGE, "Updated exchange asset '{}' custom field '{}'", exchangeAsset.getAssetId(), field);
            }
            for (String field : results.getNotDefined()) {
                logger.warn("Custom field not defined, assignment failed: " + field);
            }
            this.updateExchangeCategories(exchangeAsset);
            if (this.portal != null) {
                this.portal.provision(exchangeAsset);
            }
        }
    }

    private void updateExchangeCategories(ExchangeAsset exchangeAsset) throws HttpException {
        if (this.categories != null) {
            Map<String, List> assetCategories = exchangeAsset.getCategories().stream().collect(Collectors.toMap(AssetCategory::getKey, AssetCategory::getValue));
            for (String string : assetCategories.keySet()) {
                if (this.categories.containsKey(string)) continue;
                exchangeAsset.deleteCategory(string);
                plogger.info(EMTLogger.Product.EXCHANGE, "Updated exchange asset '{}' category '{}'", exchangeAsset.getAssetId(), string);
            }
            for (Map.Entry entry : this.categories.entrySet()) {
                String catKey;
                List assetCatValues;
                List catValues = entry.getValue() != null ? (List)entry.getValue() : Collections.emptyList();
                if (catValues.equals(assetCatValues = assetCategories.getOrDefault(catKey = (String)entry.getKey(), Collections.emptyList()))) continue;
                exchangeAsset.updateCategory(catKey, catValues);
                plogger.info(EMTLogger.Product.EXCHANGE, "Updated exchange asset '{}' category '{}' to '{}'", exchangeAsset.getAssetId(), catKey, catValues);
            }
        }
    }

    @JsonIgnore
    public String getMajorVersion() {
        return ExchangeAssetDescriptor.getMajorVersion(this.version);
    }

    public void findPages(File assetPagesDir) throws IOException {
        File[] files;
        if (assetPagesDir.exists() && assetPagesDir.isDirectory() && (files = assetPagesDir.listFiles()) != null && files.length > 0) {
            List<PortalPageDescriptor> pages;
            if (this.portal == null) {
                this.portal = new PortalDescriptor();
            }
            if ((pages = this.portal.getPages()) == null) {
                pages = new ArrayList<PortalPageDescriptor>();
                this.portal.setPages(pages);
            }
            for (File file : files) {
                String fileName;
                int idx;
                if (!file.isFile() || (idx = (fileName = file.getName()).indexOf(".")) == -1) continue;
                PortalPageDescriptor p = new PortalPageDescriptor();
                p.setContent(FileUtils.toString((File)file));
                p.setName(fileName.substring(0, idx));
                pages.add(p);
            }
        }
    }
}

