/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.cli.AbstractOrgCommand;
import com.aeontronix.enhancedmule.tools.cli.EMTCli;
import com.aeontronix.enhancedmule.tools.config.ProfileNotFoundException;
import java.io.IOException;
import picocli.CommandLine;

public class AbstractEnvCommand
extends AbstractOrgCommand {
    @CommandLine.Option(names={"-e", "--env"}, description={"Environment name or id"})
    private String envNameOrId;
    private String envId;

    public String getEnvId() throws IOException, ProfileNotFoundException, NotFoundException {
        if (this.envId == null) {
            EMTCli cli = this.getCli();
            LegacyAnypointClient anypointClient = cli.createEMClient().getLegacyAnypointClient();
            if (StringUtils.isBlank((String)this.envNameOrId)) {
                this.envNameOrId = cli.getActiveProfile().getDefaultEnv();
            }
            if (this.envNameOrId == null) {
                throw new IllegalArgumentException("Environment not specified in command line or in active configuration");
            }
            this.envId = anypointClient.findOrganizationById(this.getOrgId()).findEnvironmentByNameOrId(this.envNameOrId).getId();
        }
        return this.envId;
    }
}

