/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.properties;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.file.FileUtils;
import com.aeontronix.commons.properties.PropertiesUtils;
import com.aeontronix.enhancedmule.tools.config.ConfigProfile;
import com.aeontronix.kryptotek.CryptoUtils;
import com.aeontronix.kryptotek.DecryptionException;
import com.aeontronix.kryptotek.EncryptionException;
import com.aeontronix.kryptotek.Key;
import com.aeontronix.kryptotek.key.DecryptionKey;
import com.aeontronix.kryptotek.key.EncryptionKey;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.rmi.UnexpectedException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoHelper {
    public static final Pattern ENCRYPTED_PROP_REGEX = Pattern.compile("^\\{\\{encrypted:(.*)}}$");
    private static final Logger logger = LoggerFactory.getLogger(CryptoHelper.class);

    public static String crypt(Key key, String value, boolean encrypt) throws EncryptionException, DecryptionException {
        if (encrypt) {
            return CryptoHelper.encrypt(key, value, false);
        }
        return CryptoHelper.decrypt(key, value);
    }

    public static String encrypt(Key key, String value, boolean noExpression) throws EncryptionException {
        if (value.startsWith("{{encrypted:") && value.endsWith("}}")) {
            if (noExpression) {
                return value.substring(12, value.length() - 2);
            }
            return value;
        }
        String eval = CryptoUtils.encrypt((EncryptionKey)((EncryptionKey)key), (String)value);
        if (!noExpression) {
            eval = "{{encrypted:" + eval + "}}";
        }
        return eval;
    }

    public static String decrypt(Key key, String value) throws DecryptionException {
        Matcher matcher = ENCRYPTED_PROP_REGEX.matcher(value);
        if (matcher.find()) {
            value = matcher.group(1);
        }
        return CryptoUtils.decrypt((DecryptionKey)((DecryptionKey)key), (String)value);
    }

    static String findCryptoKey(String key, File keyFile, ConfigProfile profile) throws IOException {
        if (key != null) {
            return key;
        }
        if (keyFile != null) {
            return FileUtils.toString((File)keyFile);
        }
        return profile.getCryptoKey();
    }

    @NotNull
    public static Set<String> findSecureProperties(@NotNull File file) throws IOException {
        HashSet<String> files = new HashSet<String>();
        String nlc = file.getName().toLowerCase();
        ObjectMapper objectMapper = nlc.endsWith(".json") ? new ObjectMapper() : new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode jsonNode = objectMapper.readTree(file);
        CryptoHelper.findSecurePropertiesInPropertyMap(jsonNode, null, files);
        return files;
    }

    private static void findSecurePropertiesInPropertyMap(JsonNode jsonNode, String path, HashSet<String> files) {
        Iterator it = jsonNode.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String key = (String)entry.getKey();
            CryptoHelper.parse((JsonNode)entry.getValue(), path != null ? path + "." + key : key, files);
        }
    }

    private static void parse(JsonNode jsonNode, String path, HashSet<String> files) {
        if (CryptoHelper.isSecure(jsonNode)) {
            files.add(path);
        } else {
            JsonNode type = jsonNode.get("type");
            if (type != null && type.isTextual() && type.asText().equalsIgnoreCase("group")) {
                ObjectNode properties = (ObjectNode)jsonNode.get("properties");
                CryptoHelper.findSecurePropertiesInPropertyMap((JsonNode)properties, path, files);
            }
        }
    }

    private static boolean isSecure(JsonNode jsonNode) {
        JsonNode secure = jsonNode.get("secure");
        if (secure != null && secure.isBoolean()) {
            return secure.booleanValue();
        }
        return false;
    }

    public static void encryptProperties(Key key, File descriptorFile, File propertiesFile) throws IOException, EncryptionException {
        try {
            CryptoHelper.cryptProperties(key, descriptorFile, propertiesFile, true);
        }
        catch (DecryptionException e) {
            throw new UnexpectedException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public static void decryptProperties(Key key, File descriptorFile, File propertiesFile) throws IOException, DecryptionException {
        try {
            CryptoHelper.cryptProperties(key, descriptorFile, propertiesFile, false);
        }
        catch (EncryptionException e) {
            throw new UnexpectedException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static void cryptProperties(Key key, File propertiesFile, File filePath, boolean encrypt) throws IOException, EncryptionException, DecryptionException {
        Set<String> secureProperties = CryptoHelper.findSecureProperties(propertiesFile);
        logger.info("Secure properties: " + String.join((CharSequence)", ", secureProperties));
        if (!secureProperties.isEmpty()) {
            logger.info("Properties file: " + filePath);
            Properties properties = PropertiesUtils.readProperties((File)filePath);
            for (String sKey : secureProperties) {
                boolean expression;
                String value = properties.getProperty(sKey);
                if (!StringUtils.isNotBlank((String)value)) continue;
                boolean bl = expression = value.startsWith("{{") && value.endsWith("}}");
                if (encrypt && expression) {
                    logger.debug("Skipping property {} since it's using an expression", (Object)sKey);
                    continue;
                }
                if (!encrypt && !expression) {
                    logger.debug("Skipping property {} since it's not encrypted", (Object)sKey);
                    continue;
                }
                properties.setProperty(sKey, encrypt ? CryptoHelper.encrypt(key, value, false) : CryptoHelper.decrypt(key, value));
            }
            PropertiesUtils.writeProperties((File)filePath, (Properties)properties);
        }
    }
}

