/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.properties;

import com.aeontronix.enhancedmule.tools.cli.AbstractCommand;
import com.aeontronix.enhancedmule.tools.util.JacksonHelper;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="generate-descriptor", aliases={"gendesc"}, description={"Generate properties.xml descriptor from config file"})
public class PropertiesGenerateDescriptorCmd
extends AbstractCommand
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesGenerateDescriptorCmd.class);
    @CommandLine.Parameters(index="0")
    private File file;
    @CommandLine.Parameters(defaultValue="properties.yaml", index="1")
    private File output;
    @CommandLine.Option(names={"-t", "--tokenizer-file"}, description={"If specified also generate a tokenizer pass-through property file"})
    private File tokenizerFile;

    @Override
    public Integer call() throws Exception {
        JavaPropsMapper javaPropsMapper = new JavaPropsMapper();
        Map properties = javaPropsMapper.writeValueAsMap((Object)JacksonHelper.readTree(this.file));
        Map<String, HashMap> descriptor = properties.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new HashMap()));
        ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)YAMLFactory.builder().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).build());
        yamlMapper.writeValue(this.output, descriptor);
        logger.info("Generated file " + this.output.getPath());
        if (this.tokenizerFile != null) {
            Map<String, String> map = properties.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> "__" + (String)e.getKey() + "__"));
            javaPropsMapper.writeValue(this.tokenizerFile, map);
        }
        return null;
    }
}

