/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.util;

import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class APISpecHelper {
    @Nullable
    public static APISpecVersion findVersion(@NotNull File file) throws IOException {
        String version = null;
        if (file.exists()) {
            JsonNode info;
            Object om = file.getName().toLowerCase().endsWith("json") ? new ObjectMapper() : new YAMLMapper();
            JsonNode specNode = om.readTree(file);
            JsonNode specVersionNode = specNode.get("version");
            if (JsonHelper.isNull(specVersionNode) && JsonHelper.isNotNull(info = specNode.get("info"))) {
                specVersionNode = info.get("version");
            }
            if (specVersionNode != null) {
                version = specVersionNode.textValue();
            }
        }
        if (version == null) {
            return null;
        }
        return new APISpecVersion(version);
    }

    public static class APISpecVersion {
        private String version;
        private String nonSnapshotVersion;

        public APISpecVersion(String version) {
            this.version = version;
            int snapshotIdx = this.version.toLowerCase().indexOf("-snapshot");
            this.nonSnapshotVersion = snapshotIdx != -1 ? version.substring(0, snapshotIdx) : version;
        }

        public String getVersion() {
            return this.version;
        }

        public String getNonSnapshotVersion() {
            return this.nonSnapshotVersion;
        }
    }
}

