/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint;

import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.util.HttpHelper;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class AnypointObject<X extends AnypointObject>
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(AnypointObject.class);
    @JsonIgnore
    protected String json;
    @JacksonInject
    @JsonIgnore
    protected LegacyAnypointClient client;
    @JacksonInject
    @JsonIgnore
    protected HttpHelper httpHelper;
    @JacksonInject
    @JsonIgnore
    protected JsonHelper jsonHelper;
    @JsonIgnore
    protected X parent;

    public AnypointObject(LegacyAnypointClient client) {
        this.setClient(client);
    }

    public AnypointObject(X parent) {
        this.setParent(parent);
    }

    public AnypointObject() {
    }

    @JsonIgnore
    public LegacyAnypointClient getClient() {
        return this.client;
    }

    public void setParent(X parent) {
        this.parent = parent;
        this.setClient(((AnypointObject)parent).getClient());
    }

    public void setClient(LegacyAnypointClient client) {
        this.setClient(client, false);
    }

    public void setClient(@NotNull LegacyAnypointClient client, boolean setParent) {
        this.client = client;
        this.httpHelper = client.getHttpHelper();
        this.jsonHelper = client.getJsonHelper();
        if (logger.isDebugEnabled()) {
            logger.debug("Client assigned: " + client);
            logger.debug("httpHelper: " + this.httpHelper);
            logger.debug("jsonHelper: " + this.jsonHelper);
        }
        assert (this.httpHelper != null && this.jsonHelper != null && this.client != null);
        if (setParent && this.parent != null) {
            ((AnypointObject)this.parent).setClient(client);
        }
    }

    @JsonIgnore
    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public X getParent() {
        return this.parent;
    }
}

