/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.runtime;

import com.aeontronix.commons.ThreadUtils;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.runtime.ApplicationDeploymentFailedException;
import com.aeontronix.enhancedmule.tools.runtime.CHApplication;
import com.aeontronix.enhancedmule.tools.runtime.DeploymentResult;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHDeploymentResult
extends DeploymentResult {
    public static final String UNDEPLOYED = "UNDEPLOYED";
    static final String DEPLOYMENT_FAILED = "DEPLOYMENT_FAILED";
    static final String DEPLOY_FAILED = "DEPLOY_FAILED";
    static final String STARTED = "STARTED";
    private static final Logger logger = LoggerFactory.getLogger(CHDeploymentResult.class);
    private CHApplication application;

    public CHDeploymentResult(CHApplication application) {
        this.application = application;
    }

    @Override
    public void waitDeployed(long timeout, long retryDelay) throws HttpException, ApplicationDeploymentFailedException {
        ThreadUtils.sleep((long)5000L);
        LinkedList<String> history = new LinkedList<String>();
        String lastStatus = null;
        long expires = System.currentTimeMillis() + timeout;
        long lastUpdt = this.application.getLastUpdateTime();
        while (true) {
            try {
                this.application = this.application.refresh();
                String status = this.application.getStatus();
                if (lastStatus == null || !lastStatus.equals(status)) {
                    history.add(status);
                    lastStatus = status;
                }
                if (DEPLOYMENT_FAILED.equalsIgnoreCase(status)) {
                    logger.error("Deployment failed due to status: " + status + " history=" + history);
                    throw new ApplicationDeploymentFailedException();
                }
                if (DEPLOY_FAILED.equalsIgnoreCase(this.application.getDeploymentUpdateStatus())) {
                    logger.error("Deployment failed due to deployment update status: " + this.application.getDeploymentUpdateStatus() + " history=" + history);
                    throw new ApplicationDeploymentFailedException();
                }
                if (status.equalsIgnoreCase(STARTED) && this.application.getDeploymentUpdateStatus() == null && this.application.getLastUpdateTime() > lastUpdt) {
                    return;
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if (expires <= System.currentTimeMillis()) break;
            ThreadUtils.sleep((long)retryDelay);
        }
        logger.error("Deployment failed due to timeout. history=" + history);
        throw new ApplicationDeploymentFailedException();
    }
}

