/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.application.portal;

import com.aeontronix.commons.file.FileUtils;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAsset;
import com.aeontronix.enhancedmule.tools.application.portal.PortalPageDescriptor;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(PortalDescriptor.class);
    private static final EMTLogger plogger = new EMTLogger(logger);
    private List<PortalPageDescriptor> pages;

    public List<PortalPageDescriptor> getPages() {
        return this.pages;
    }

    public void setPages(List<PortalPageDescriptor> pages) {
        this.pages = pages;
    }

    public void provision(ExchangeAsset exchangeAsset) throws IOException {
        if (this.pages != null) {
            for (PortalPageDescriptor page : this.pages) {
                String pageContent;
                String expectedPage = page.getContent() != null ? page.getContent() : FileUtils.toString((File)new File(page.getPath()));
                try {
                    pageContent = exchangeAsset.getPage(page.getName());
                }
                catch (NotFoundException e) {
                    pageContent = null;
                }
                if (pageContent != null && pageContent.equals(expectedPage)) continue;
                String pageName = page.getName();
                if (pageName.equalsIgnoreCase("home")) {
                    pageName = "home";
                }
                exchangeAsset.updatePage(pageName, expectedPage);
                plogger.info(EMTLogger.Product.EXCHANGE, "Updated portal page {} : {}", exchangeAsset.getAssetId(), page.getName());
            }
        }
    }
}

