/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.authentication;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.anypoint.authentication.AuthenticationProvider;
import com.aeontronix.enhancedmule.tools.util.AnypointAccessToken;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.HttpHelper;
import com.aeontronix.restclient.RESTClient;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.RESTRequest;
import com.aeontronix.restclient.auth.AuthenticationHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class AuthenticationProviderUsernamePasswordImpl
extends AuthenticationProvider
implements AuthenticationHandler {
    public static final String LOGIN_PATH = "/accounts/login";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private String bearerToken;
    private String username;
    private String password;

    public AuthenticationProviderUsernamePasswordImpl(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public AnypointAccessToken getBearerToken(HttpHelper httpHelper) throws HttpException {
        try {
            if (StringUtils.isBlank((String)this.username)) {
                throw new IllegalArgumentException("Username missing");
            }
            if (StringUtils.isBlank((String)this.password)) {
                throw new IllegalArgumentException("Password missing");
            }
            HashMap<String, String> request = new HashMap<String, String>();
            request.put("username", this.username);
            request.put("password", this.password);
            httpHelper.setLoginRequest(true);
            Map data = (Map)this.objectMapper.readValue(httpHelper.httpPost(LOGIN_PATH, request), Map.class);
            return new AnypointAccessToken((String)data.get("access_token"));
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public String filterSecret(String resStr) {
        return resStr.replace(this.password, "**********");
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void refreshCredential(RESTClient restClient) throws RESTException {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("username", this.username);
        request.put("password", this.password);
        Map result = (Map)restClient.get(URI.create("https://anypoint.mulesoft.com/login")).executeAndConvertToObject(Map.class);
        this.bearerToken = (String)result.get("access_token");
        if (StringUtils.isBlank((String)this.bearerToken)) {
            throw new RESTException("Login service didn't return valid bearer token");
        }
    }

    public boolean isRefreshRequired() {
        return this.bearerToken == null;
    }

    public boolean isRefreshable() {
        return true;
    }

    public void applyCredentials(RESTRequest request) {
        if (this.bearerToken != null) {
            request.setHeader("Authorization", "bearer " + this.bearerToken);
        }
    }
}

