/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.config;

import com.aeontronix.enhancedmule.tools.cli.EMTCli;
import com.aeontronix.enhancedmule.tools.cli.config.ConfigCmd;
import com.aeontronix.enhancedmule.tools.config.ConfigProfile;
import java.net.URL;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="server", description={"Set server URL in configuration"})
public class ConfigSetServerCmd
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigSetServerCmd.class);
    @CommandLine.ParentCommand
    private ConfigCmd configCmd;
    @CommandLine.Parameters(description={"Server URL"}, arity="0..1")
    private URL serverURL;

    @Override
    public Integer call() throws Exception {
        EMTCli cli = this.configCmd.getCli();
        ConfigProfile profile = cli.getActiveProfile();
        if (this.serverURL != null) {
            profile.setServerUrl(this.serverURL.toString());
            logger.info("Server URL updated to " + this.serverURL.toString());
        } else {
            profile.setServerUrl(null);
            logger.info("Using enhanced mule cloud server");
        }
        cli.saveConfig();
        return 0;
    }
}

