/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.properties;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.cli.AbstractCommand;
import com.aeontronix.enhancedmule.tools.cli.properties.CryptoHelper;
import com.aeontronix.enhancedmule.tools.cli.properties.EncryptCmd;
import com.aeontronix.kryptotek.CryptoUtils;
import com.aeontronix.kryptotek.Key;
import java.io.File;
import java.util.concurrent.Callable;
import picocli.CommandLine;

public abstract class AbstractCryptoCmd
extends AbstractCommand
implements Callable<Integer> {
    @CommandLine.ArgGroup(exclusive=true, multiplicity="0..1")
    protected EncryptCmd.KeyOptions keyOptions;
    @CommandLine.Option(names={"-v", "--value"}, description={"Text to encrypt"}, arity="1")
    protected String value;
    @CommandLine.Option(names={"-d", "--descriptor-path"}, description={"Property definition file path"}, defaultValue="src/main/resources/properties.yaml", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    protected File descPath;
    @CommandLine.Option(names={"-p", "--file-path"}, description={"Property file path"}, defaultValue="src/main/resources/properties-local.yaml", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    protected File filePath;

    @Override
    public Integer call() throws Exception {
        String cryptoKey;
        if (this.keyOptions == null) {
            this.keyOptions = new EncryptCmd.KeyOptions();
        }
        if (StringUtils.isBlank((String)(cryptoKey = CryptoHelper.findCryptoKey(this.keyOptions.key, this.keyOptions.keyFile, this.getCli().getActiveProfile())))) {
            throw new IllegalArgumentException("No cryptography key found in profile or parameters");
        }
        Key key = CryptoUtils.readKey((String)cryptoKey);
        this.run(key, this.value);
        return null;
    }

    public abstract int run(Key var1, String var2) throws Exception;
}

