/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.role;

import com.aeontronix.commons.URLBuilder;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.role.RoleGroup;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.aeontronix.enhancedmule.tools.util.PaginatedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleGroupList
extends PaginatedList<RoleGroup, Organization> {
    private static final Logger logger = LoggerFactory.getLogger(RoleGroupList.class);

    public RoleGroupList(Organization org) throws HttpException {
        this(org, 50);
    }

    public RoleGroupList(Organization org, int limit) throws HttpException {
        super(org, limit);
        this.download();
    }

    @Override
    @NotNull
    protected URLBuilder buildUrl() {
        return new URLBuilder("/accounts/api/organizations/").path(((Organization)this.parent).getId()).path("rolegroups").queryParam("include_internal", false);
    }

    @Override
    protected void parseJson(String json, JsonHelper jsonHelper) {
        this.list = jsonHelper.readJsonList(RoleGroup.class, json, this.parent, "/data");
    }

    public List<RoleGroup> getRoleGroups() {
        return this.list;
    }

    public void setRoleGroups(List<RoleGroup> roleGroups) {
        this.list = roleGroups;
    }
}

