/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.api;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.exchange.ExchangeClientApplication;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.api.API;
import com.aeontronix.enhancedmule.tools.anypoint.api.APIContract;
import com.aeontronix.enhancedmule.tools.anypoint.api.SLATier;
import com.aeontronix.enhancedmule.tools.anypoint.api.SLATierList;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetInstance;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.json.JsonConvertionException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientApplication
extends AnypointObject<Organization> {
    private static final Logger logger = LoggerFactory.getLogger(ClientApplication.class);
    private ExchangeClientApplication app;

    public ClientApplication(ExchangeClientApplication clientApplication, Organization organization) {
        super(organization);
        this.app = clientApplication;
    }

    @JsonProperty
    public Integer getId() {
        return this.app.getId();
    }

    public void setId(Integer id) {
        this.app.setId(id.intValue());
    }

    @JsonProperty
    public String getName() {
        return this.app.getName();
    }

    public void setName(String name) {
        this.app.setName(name);
    }

    @JsonProperty
    public String getDescription() {
        return this.app.getDescription();
    }

    public void setDescription(String description) {
        this.app.setDescription(description);
    }

    @JsonProperty
    public String getUrl() {
        return this.app.getUrl();
    }

    public void setUrl(String url) {
        this.app.getUrl();
    }

    @JsonProperty
    public String getClientId() {
        return this.app.getClientId();
    }

    public void setClientId(String clientId) {
        this.app.setClientId(clientId);
    }

    @JsonProperty
    public String getClientSecret() {
        return this.app.getClientSecret();
    }

    public void setClientSecret(String clientSecret) {
        this.app.setClientSecret(clientSecret);
    }

    @JsonIgnore
    public String getUriPath() {
        return ((Organization)this.parent).getUriPath() + "/applications/" + this.getId();
    }

    public static ClientApplication create(AnypointClient anypointClient, @NotNull Organization organization, @NotNull String name, String url, String description, List<String> redirectUri, String apiEndpoints, String accessedAPIInstanceId) throws HttpException {
        try {
            ExchangeClientApplication clientApplication = anypointClient.getExchangeClient().createClientApplication(organization.getId(), name, url, description, redirectUri, null, apiEndpoints, accessedAPIInstanceId);
            return new ClientApplication(clientApplication, organization);
        }
        catch (RESTException | JsonConvertionException e) {
            throw new HttpException(e);
        }
    }

    public static List<ClientApplication> find(AnypointClient client, LegacyAnypointClient legacyAnypointClient, Organization organization, String filter) throws HttpException {
        ArrayList<ClientApplication> list = new ArrayList<ClientApplication>();
        try {
            List clientApplications = client.getExchangeClient().listClientApplications(organization.getId());
            for (ExchangeClientApplication clientApplication : clientApplications) {
                if (!clientApplication.getName().contains(filter)) continue;
                list.add(new ClientApplication(clientApplication, organization));
            }
        }
        catch (RESTException e) {
            throw new HttpException(e);
        }
        return list;
    }

    public void delete() throws HttpException {
        this.httpHelper.httpDelete(this.getUriPath());
    }

    public APIContract requestAPIAccess(API apiVersion) throws HttpException {
        return this.requestAPIAccess(apiVersion, null, false);
    }

    public APIContract requestAPIAccess(API apiVersion, SLATier tier) throws HttpException {
        return this.requestAPIAccess(apiVersion, tier, true);
    }

    public APIContract requestAPIAccess(API apiVersion, SLATier tier, boolean acceptedTerms) throws HttpException {
        SLATierList apiTiers;
        Long tierId;
        if (this.jsonHelper == null) {
            this.client = apiVersion.getClient();
            this.jsonHelper = this.client.getJsonHelper();
            this.httpHelper = this.client.getHttpHelper();
        }
        JsonHelper.MapBuilder mapBuilder = this.jsonHelper.buildJsonMap().set("apiId", apiVersion.getId()).set("environmentId", ((Environment)apiVersion.getParent()).getId()).set("acceptedTerms", acceptedTerms).set("organizationId", ((Organization)((Environment)apiVersion.getParent()).getParent()).getId()).set("groupId", apiVersion.getGroupId()).set("assetId", apiVersion.getAssetId()).set("version", apiVersion.getAssetVersion()).set("productAPIVersion", apiVersion.getProductVersion());
        if (tier != null && tier.getId() == null) {
            throw new IllegalArgumentException("Tier is missing tier id");
        }
        Long l = tierId = tier != null ? tier.getId() : null;
        if (tierId == null && (apiTiers = apiVersion.findSLATiers()).size() == 1) {
            tierId = ((SLATier)apiTiers.iterator().next()).getId();
        }
        if (tierId != null) {
            mapBuilder.set("requestedTierId", tierId);
        }
        Map<String, Object> req = mapBuilder.toMap();
        String json = this.httpHelper.httpPost("/exchange/api/v1/organizations/" + ((Organization)this.parent).getId() + "/applications/" + this.getId() + "/contracts", req);
        return this.jsonHelper.readJson(new APIContract(apiVersion), json);
    }

    public APIContract requestAPIAccess(API api, AssetInstance assetInstance) throws HttpException {
        return this.requestAPIAccess(api, assetInstance, null, false);
    }

    public APIContract requestAPIAccess(API api, AssetInstance assetInstance, SLATier tier) throws HttpException {
        return this.requestAPIAccess(api, assetInstance, tier, true);
    }

    public APIContract requestAPIAccess(API api, AssetInstance apiVersion, SLATier tier, boolean acceptedTerms) throws HttpException {
        Long tierId;
        JsonHelper.MapBuilder mapBuilder = this.jsonHelper.buildJsonMap().set("apiId", apiVersion.getId()).set("environmentId", apiVersion.getEnvironmentId()).set("acceptedTerms", acceptedTerms).set("organizationId", apiVersion.getOrganizationId()).set("groupId", apiVersion.getGroupId()).set("assetId", apiVersion.getAssetId()).set("version", apiVersion.getVersion()).set("productAPIVersion", apiVersion.getProductAPIVersion());
        if (tier != null && tier.getId() == null) {
            throw new IllegalArgumentException("Tier is missing tier id");
        }
        Long l = tierId = tier != null ? tier.getId() : null;
        if (tierId != null) {
            mapBuilder.set("requestedTierId", tierId);
        }
        Map<String, Object> req = mapBuilder.toMap();
        String json = this.httpHelper.httpPost("/exchange/api/v1/organizations/" + ((Organization)this.parent).getId() + "/applications/" + this.getId() + "/contracts", req);
        return this.jsonHelper.readJson(new APIContract(api), json);
    }
}

