/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.util;

import com.aeontronix.commons.URLBuilder;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PaginatedList<X, Z extends AnypointObject>
implements Iterable<X> {
    protected Z parent;
    protected int limit = 100;
    protected int offset = 0;
    protected int total = -1;
    protected List<X> list;

    public PaginatedList(Z parent) {
        this.parent = parent;
    }

    public PaginatedList(Z parent, int limit) {
        this(parent);
        this.limit = limit;
    }

    @NotNull
    protected abstract URLBuilder buildUrl();

    public void download() throws HttpException {
        String url = this.buildUrl().queryParam("limit", this.limit).queryParam("offset", this.offset).toString();
        String json = ((AnypointObject)this.parent).getClient().getHttpHelper().httpGet(url);
        JsonHelper jsonHelper = ((AnypointObject)this.parent).getClient().getJsonHelper();
        this.parseJson(json, jsonHelper);
    }

    protected void parseJson(String json, JsonHelper jsonHelper) {
        jsonHelper.readJson(this, json);
        for (X obj : this.list) {
            if (!(obj instanceof AnypointObject)) continue;
            ((AnypointObject)obj).setParent(this.parent);
        }
    }

    @JsonProperty
    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int size() {
        return this.list != null ? this.list.size() : -1;
    }

    public List<X> getAll() {
        ArrayList l = new ArrayList();
        this.forEach(l::add);
        return l;
    }

    @Override
    @NotNull
    public Iterator<X> iterator() {
        return new PaginatingIterator();
    }

    public class PaginatingIterator
    implements Iterator<X> {
        private Iterator<X> iterator;

        public PaginatingIterator() {
            this.iterator = PaginatedList.this.list.iterator();
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.iterator.hasNext();
            if (!hasNext) {
                PaginatedList.this.offset += PaginatedList.this.limit;
                try {
                    PaginatedList.this.download();
                    if (PaginatedList.this.list.isEmpty()) {
                        return false;
                    }
                    this.iterator = PaginatedList.this.list.iterator();
                }
                catch (HttpException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return true;
        }

        @Override
        public X next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

