/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.application.api;

import com.aeontronix.commons.validation.ValidationUtils;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.api.API;
import com.aeontronix.enhancedmule.tools.anypoint.api.APISpec;
import com.aeontronix.enhancedmule.tools.anypoint.api.SLATier;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAssetDescriptor;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ProvisioningException;
import com.aeontronix.enhancedmule.tools.application.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.APIDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.APIProvisioningResult;
import com.aeontronix.enhancedmule.tools.application.api.PolicyDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.SLATierDescriptor;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleAPIProvisioningService {
    private static final Logger logger = LoggerFactory.getLogger(MuleAPIProvisioningService.class);
    private static final EMTLogger plogger = new EMTLogger(logger);
    private LegacyAnypointClient client;

    public MuleAPIProvisioningService(LegacyAnypointClient client) {
        this.client = client;
    }

    public void provisionAPI(APIDescriptor apiDescriptor, ApplicationDescriptor cfg, Environment environment, APIProvisioningResult result) throws ProvisioningException {
        try {
            List<SLATierDescriptor> slaTiers;
            API api;
            ExchangeAssetDescriptor asset = apiDescriptor.getAsset();
            ValidationUtils.notNull(IllegalStateException.class, (String)"API Descriptor missing value: asset", (Object[])new Object[]{asset});
            String label = apiDescriptor.getLabel();
            String consumerUrl = apiDescriptor.getConsumerUrl();
            Organization organization = (Organization)environment.getParent();
            Map<String, Object> implementationUrlJson = apiDescriptor.getImplementationUrlJson();
            String implementationUrl = apiDescriptor.getImplementationUrl();
            String assetId = asset.getId();
            ValidationUtils.notNull(IllegalStateException.class, (String)"API asset id cannot be null", (Object[])new Object[]{apiDescriptor});
            String assetVersion = asset.getVersion();
            ValidationUtils.notNull(IllegalStateException.class, (String)"API asset version cannot be null", (Object[])new Object[]{apiDescriptor});
            logger.info(Ansi.ansi().a("Provisioning ").fgGreen().a(assetId).reset().a(":").fgGreen().a(assetVersion).reset().a(" within org ").fgGreen().a(organization.getName()).reset().a(", env ").fgGreen().a(environment.getName()).toString());
            Boolean m3 = cfg.getMule3();
            if (m3 == null) {
                m3 = false;
            }
            try {
                api = environment.findAPIByExchangeAssetIdOrNameAndVersion(assetId, assetVersion, label);
                logger.debug("API " + assetId + " " + assetVersion + " exists: " + api);
            }
            catch (NotFoundException e) {
                logger.debug("API " + assetId + " " + assetVersion + " not found, creating");
                APISpec apiSpec = organization.findAPISpecsByIdOrNameAndVersion(assetId, assetVersion);
                String productAPIVersion = apiSpec.getProductAPIVersion();
                try {
                    logger.debug("findAPIByExchangeAssetIdOrNameAndProductAPIVersion: {} , {} , {}", new Object[]{assetId, productAPIVersion, label});
                    api = environment.findAPIByExchangeAssetIdOrNameAndProductAPIVersion(assetId, productAPIVersion, label);
                    String currentAssetVersion = api.getAssetVersion();
                    if (!currentAssetVersion.equalsIgnoreCase(assetVersion)) {
                        api.updateVersion(assetVersion);
                        plogger.info(EMTLogger.Product.API_MANAGER, "Updated api {} version to {}", assetId, assetVersion);
                    }
                }
                catch (NotFoundException ex) {
                    logger.debug("Creating API");
                    api = implementationUrlJson != null ? environment.createAPI(apiSpec, label, implementationUrlJson, consumerUrl) : environment.createAPI(apiSpec, m3 == false, implementationUrl, consumerUrl, label, asset.getType());
                    plogger.info(EMTLogger.Product.API_MANAGER, "Created api {}", api.getAssetId(), assetVersion);
                }
            }
            List<PolicyDescriptor> policies = apiDescriptor.getPolicies();
            if (policies != null && !policies.isEmpty()) {
                plogger.info(EMTLogger.Product.API_MANAGER, "Setting policies for {}: {}", api.getAssetId(), policies.stream().map(PolicyDescriptor::getAssetId).collect(Collectors.joining(", ")));
                api.deletePolicies();
                for (PolicyDescriptor policyDescriptor : policies) {
                    logger.info("Creating policy {}:{}:{}", new Object[]{policyDescriptor.getGroupId(), policyDescriptor.getAssetId(), policyDescriptor.getAssetVersion()});
                    api.createPolicy(policyDescriptor);
                }
            }
            if ((slaTiers = apiDescriptor.getSlaTiers()) != null && !slaTiers.isEmpty()) {
                plogger.info(EMTLogger.Product.API_MANAGER, "Setting SLA Tiers for {}", api.getAssetId());
                for (SLATierDescriptor slaTierDescriptor : slaTiers) {
                    try {
                        SLATier slaTier = api.findSLATier(slaTierDescriptor.getName());
                        slaTier.setAutoApprove(slaTierDescriptor.isAutoApprove());
                        slaTier.setDescription(slaTierDescriptor.getDescription());
                        slaTier.setLimits(slaTierDescriptor.getLimits());
                        plogger.info(EMTLogger.Product.API_MANAGER, "Updating SLA Tiers {}", slaTierDescriptor.getName());
                        slaTier = slaTier.update();
                    }
                    catch (NotFoundException e) {
                        plogger.info(EMTLogger.Product.API_MANAGER, "Creating SLA Tiers {}", slaTierDescriptor.getName());
                        api.createSLATier(slaTierDescriptor.getName(), slaTierDescriptor.getDescription(), slaTierDescriptor.isAutoApprove(), slaTierDescriptor.getLimits());
                    }
                }
            }
            if (consumerUrl != null) {
                this.updateConsumerUrl(api, consumerUrl);
                plogger.info(EMTLogger.Product.API_MANAGER, "Updated consumer url to {}", consumerUrl);
            }
            if (implementationUrlJson != null) {
                api.updateImplementationUrl(implementationUrlJson);
                plogger.info(EMTLogger.Product.API_MANAGER, "Updated implementation url to {}", implementationUrlJson.toString());
            } else if (implementationUrl != null) {
                api.updateImplementationUrl(implementationUrl, m3 == false, asset.getType());
                plogger.info(EMTLogger.Product.API_MANAGER, "Updated implementation url to {}", implementationUrl);
            }
            api = api.refresh();
            result.setApi(api);
            if (logger.isDebugEnabled()) {
                logger.debug("api: {}", (Object)api.toString());
            }
            asset.provision(environment.getOrganization());
        }
        catch (NotFoundException | IOException e) {
            throw new ProvisioningException(e);
        }
    }

    public void updateConsumerUrl(API api, String consumerUrl) throws HttpException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("endpointUri", consumerUrl);
        this.client.getHttpHelper().httpPatch(api.getUrl(), data);
    }
}

