/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.properties;

import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.commons.file.FileUtils;
import com.aeontronix.enhancedmule.tools.cli.AbstractCommand;
import com.aeontronix.enhancedmule.tools.cli.EMTCli;
import com.aeontronix.kryptotek.CryptoUtils;
import com.aeontronix.kryptotek.EncodedKey;
import com.aeontronix.kryptotek.InvalidKeyEncodingException;
import com.aeontronix.kryptotek.key.AESKeyLen;
import com.aeontronix.kryptotek.key.RSAKeyPair;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="keygen", description={"Generate a property encryption key"})
public class KeyGenCmd
extends AbstractCommand
implements Callable<Integer> {
    @CommandLine.Parameters(description={"File to write key to"}, arity="0..1")
    private File file;
    @CommandLine.Option(names={"-s", "--save"}, description={"Save key to active profile"}, defaultValue="false")
    private boolean save;
    @CommandLine.Option(names={"-r", "--rsa"}, description={"Generate an RSA key pair instead of an AES key"}, defaultValue="false")
    private boolean rsa;

    @Override
    public Integer call() throws Exception {
        String key;
        try {
            if (this.rsa) {
                RSAKeyPair rsaKeyPair = CryptoUtils.generateRSAKeyPair((int)4096);
                EncodedKey encodedKey = rsaKeyPair.getEncoded(EncodedKey.Format.B64);
                key = encodedKey.getEncodedKeyString();
                if (this.file != null) {
                    FileUtils.write((File)this.file, (byte[])encodedKey.getEncodedKeyData());
                } else {
                    System.out.println("Private Key: " + encodedKey.getEncodedKeyString());
                }
                System.out.println("Public key: " + rsaKeyPair.getPublicKey().getEncoded(EncodedKey.Format.B64).getEncodedKeyString());
            } else {
                EncodedKey encodedKey = CryptoUtils.generateAESKey((AESKeyLen)AESKeyLen.AES256).getEncoded(EncodedKey.Format.B64);
                key = encodedKey.getEncodedKeyString();
                if (this.file != null) {
                    FileUtils.write((File)this.file, (byte[])encodedKey.getEncodedKeyData());
                } else {
                    System.out.println(key);
                }
            }
        }
        catch (InvalidKeyEncodingException | IOException e) {
            throw new UnexpectedException(e);
        }
        if (this.save) {
            EMTCli cli = this.getCli();
            cli.getActiveProfile().setCryptoKey(key);
            cli.saveConfig();
        }
        return 0;
    }
}

